/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.markers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;

public abstract class SpecfileMarkerHandler {
    IDocument document;
    IFile file;

    public SpecfileMarkerHandler(IFile file, IDocument document) {
        this.file = file;
        this.document = document;
    }

    abstract String getMarkerID();

    protected Integer getCharOffset(int lineNumber, int columnNumber) {
        try {
            return this.document.getLineOffset(lineNumber) + columnNumber;
        }
        catch (BadLocationException e) {
            SpecfileLog.logError(e);
            return null;
        }
    }

    public void removeExistingMarkers() {
        if (this.file == null || !this.file.exists()) {
            return;
        }
        try {
            this.file.deleteMarkers(this.getMarkerID(), true, 0);
        }
        catch (CoreException e1) {
            SpecfileLog.logError(e1);
        }
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }
}

