/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;

public class TaskEditorExtensionReader {
    private static final String CONNECTOR_KIND = "connectorKind";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String EXTENSION_TASK_EDITOR_EXTENSIONS = "org.eclipse.mylyn.tasks.ui.taskEditorExtensions";
    private static final String REPOSITORY_ASSOCIATION = "repositoryAssociation";
    private static final String TASK_EDITOR_EXTENSION = "taskEditorExtension";

    public static void initExtensions() {
        IExtension[] editorExtensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint editorExtensionPoint = registry.getExtensionPoint(EXTENSION_TASK_EDITOR_EXTENSIONS);
        IExtension[] iExtensionArray = editorExtensions = editorExtensionPoint.getExtensions();
        int n = editorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(TASK_EDITOR_EXTENSION)) {
                    TaskEditorExtensionReader.readEditorExtension(element);
                } else if (element.getName().equals(REPOSITORY_ASSOCIATION)) {
                    TaskEditorExtensionReader.readEditorExtensionAssociation(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void readEditorExtension(IConfigurationElement element) {
        try {
            String id = element.getAttribute(ATTR_ID);
            String name = element.getAttribute(ATTR_NAME);
            AbstractTaskEditorExtension extension = (AbstractTaskEditorExtension)element.createExecutableExtension("class");
            TaskEditorExtensions.addTaskEditorExtension(element.getNamespaceIdentifier(), id, name, extension);
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load taskEditorExtension", e));
        }
    }

    private static void readEditorExtensionAssociation(IConfigurationElement element) {
        try {
            String repository = element.getAttribute(CONNECTOR_KIND);
            String taskEditorExtension = element.getAttribute(TASK_EDITOR_EXTENSION);
            TaskEditorExtensions.addRepositoryAssociation(repository, taskEditorExtension);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load repositoryAssociation", (Throwable)e));
        }
    }
}

