/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.debugsources;

import java.util.Set;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesTreeElement;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class DebugSourcesTreeContentProvider
implements ITreeContentProvider {
    private boolean flattenFoldersWithNoFiles = true;
    private boolean showExistingFilesOnly = true;

    public void setFlattenFoldersWithNoFiles(boolean flattenFoldersWithNoFiles) {
        this.flattenFoldersWithNoFiles = flattenFoldersWithNoFiles;
    }

    public boolean isFlattenFoldersWithNoFiles() {
        return this.flattenFoldersWithNoFiles;
    }

    public void setShowExistingFilesOnly(boolean showExistingFilesOnly) {
        this.showExistingFilesOnly = showExistingFilesOnly;
    }

    public boolean isShowExistingFilesOnly() {
        return this.showExistingFilesOnly;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DebugSourcesTreeElement) {
            DebugSourcesTreeElement tree = (DebugSourcesTreeElement)inputElement;
            Set<DebugSourcesTreeElement> children = tree.getChildren(this.showExistingFilesOnly);
            return children.toArray();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DebugSourcesTreeElement) {
            DebugSourcesTreeElement child;
            DebugSourcesTreeElement tree = (DebugSourcesTreeElement)parentElement;
            Set<DebugSourcesTreeElement> children = tree.getChildren(this.showExistingFilesOnly);
            if (this.flattenFoldersWithNoFiles && children.size() == 1 && (child = children.iterator().next()).getFullPath() == null) {
                return this.getChildren(child);
            }
            return children.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof DebugSourcesTreeElement) {
            Set<DebugSourcesTreeElement> children;
            DebugSourcesTreeElement grandParent;
            DebugSourcesTreeElement node = (DebugSourcesTreeElement)element;
            DebugSourcesTreeElement parent = node.getParent();
            if (parent == null) {
                return null;
            }
            if (this.flattenFoldersWithNoFiles && (grandParent = parent.getParent()) != null && (children = grandParent.getChildren(this.showExistingFilesOnly)).size() == 1) {
                return this.getParent(parent);
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DebugSourcesTreeElement) {
            return this.getChildren(element).length > 0;
        }
        return false;
    }
}

