/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IElementFormatProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.MessagesForNumberFormat;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.NumberFormatsContribution;
import org.eclipse.cdt.dsf.ui.concurrent.SimpleDisplayExecutor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICacheEntry;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICachingVMProviderExtension2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ElementNumberFormatsContribution
extends NumberFormatsContribution {
    protected static IContributionItem[] NO_ITEMS = new IContributionItem[]{new ContributionItem(){

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0);
            item.setEnabled(false);
            item.setText(MessagesForNumberFormat.NumberFormatContribution_EmptyFormatsList_label);
        }

        public boolean isEnabled() {
            return false;
        }
    }};

    @Override
    protected IContributionItem[] getContributionItems() {
        TreePath[] elementPaths;
        ISelection selection = VMHandlerUtils.getSelection(this.fServiceLocator);
        if (selection == null || selection.isEmpty() || !(selection instanceof ITreeSelection)) {
            return NO_ITEMS;
        }
        IVMProvider provider = VMHandlerUtils.getVMProviderForSelection(selection);
        if (!(provider instanceof IElementFormatProvider)) {
            return NO_ITEMS;
        }
        IPresentationContext context = provider.getPresentationContext();
        Object viewerInput = VMHandlerUtils.getViewerInput(context);
        List<String> availableFormats = this.getAvailableFormats(provider, viewerInput, elementPaths = ((ITreeSelection)selection).getPaths());
        if (availableFormats.size() == 0) {
            return NO_ITEMS;
        }
        IVMNode[] nodes = new IVMNode[elementPaths.length];
        final ArrayList<SelectFormatAction> actions = new ArrayList<SelectFormatAction>(availableFormats.size());
        for (String formatId : availableFormats) {
            actions.add(new SelectFormatAction((IElementFormatProvider)((Object)provider), context, nodes, viewerInput, elementPaths, formatId));
        }
        final String[] elementActiveFormats = new String[elementPaths.length];
        CountingRequestMonitor crm = new CountingRequestMonitor(SimpleDisplayExecutor.getSimpleDisplayExecutor(Display.getDefault()), null){

            protected void handleCompleted() {
                String activeFormat = null;
                int i = 0;
                while (i < elementActiveFormats.length) {
                    if (i == 0) {
                        activeFormat = elementActiveFormats[i];
                    } else if (activeFormat != null && !activeFormat.equals(elementActiveFormats[i])) {
                        activeFormat = null;
                        break;
                    }
                    ++i;
                }
                if (activeFormat != null) {
                    i = 0;
                    while (i < actions.size()) {
                        if (activeFormat.equals(((SelectFormatAction)((Object)actions.get((int)i))).fFormatId)) {
                            ((SelectFormatAction)((Object)actions.get(i))).setChecked(true);
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
        int i = 0;
        while (i < elementPaths.length) {
            Object segment = elementPaths[i].getLastSegment();
            nodes[i] = segment instanceof IVMContext ? ((IVMContext)segment).getVMNode() : null;
            final int index = i;
            ((IElementFormatProvider)((Object)provider)).getActiveFormat(context, nodes[i], viewerInput, elementPaths[i], new DataRequestMonitor<String>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                protected void handleSuccess() {
                    elementActiveFormats[index] = (String)this.getData();
                    super.handleSuccess();
                }
            });
            ++i;
        }
        crm.setDoneCount(elementPaths.length);
        int count = actions.size();
        IContributionItem[] items = new IContributionItem[count];
        int i2 = 0;
        while (i2 < items.length) {
            items[i2] = new ActionContributionItem((IAction)actions.get(i2));
            ++i2;
        }
        return items;
    }

    private List<String> getAvailableFormats(IVMProvider provider, Object viewerInput, TreePath[] paths) {
        if (provider instanceof ICachingVMProviderExtension2) {
            ICachingVMProviderExtension2 cachingProvider = (ICachingVMProviderExtension2)provider;
            Object[] formats = null;
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                ICacheEntry cacheEntry;
                TreePath path = treePathArray[n2];
                IVMNode node = VMHandlerUtils.getVMNode(viewerInput, path);
                if (node != null && (cacheEntry = cachingProvider.getCacheEntry(node, viewerInput, path)) != null && cacheEntry.getProperties() != null) {
                    Object[] entryFormats = (String[])cacheEntry.getProperties().get("formatted_value_available_formats");
                    if (entryFormats == null) {
                        return FORMATS;
                    }
                    if (formats == null) {
                        formats = entryFormats;
                    } else if (!Arrays.equals(formats, entryFormats)) {
                        return FORMATS;
                    }
                }
                ++n2;
            }
            if (formats != null) {
                return Arrays.asList(formats);
            }
        }
        return FORMATS;
    }

    static class SelectFormatAction
    extends Action {
        private final IElementFormatProvider fProvider;
        private final IPresentationContext fContext;
        private final IVMNode[] fNodes;
        private final Object fViewerInput;
        private final TreePath[] fElementPaths;
        private final String fFormatId;

        SelectFormatAction(IElementFormatProvider provider, IPresentationContext context, IVMNode[] nodes, Object viewerInput, TreePath[] elementPaths, String formatId) {
            super(formatId == null ? MessagesForNumberFormat.ElementNumberFormatContribution_RestoreToPreference_label : FormattedValueVMUtil.getFormatLabel(formatId), formatId == null ? 1 : 8);
            this.fProvider = provider;
            this.fContext = context;
            this.fNodes = nodes;
            this.fViewerInput = viewerInput;
            this.fElementPaths = elementPaths;
            this.fFormatId = formatId;
        }

        public void run() {
            if (this.fFormatId == null) {
                this.fProvider.setActiveFormat(this.fContext, this.fNodes, this.fViewerInput, this.fElementPaths, this.fFormatId);
                return;
            }
            if (this.isChecked()) {
                this.fProvider.setActiveFormat(this.fContext, this.fNodes, this.fViewerInput, this.fElementPaths, this.fFormatId);
            }
        }
    }
}

