/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties.methods.ia2text;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.AbstractInputField;
import org.eclipse.actf.visualization.gui.msaa.properties.fields.TextOffsetField;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.MethodData;

public class IA2TextTextMethod
extends MethodData {
    private AccessibleText accessibleText;
    private TextOffsetField startOffsetField;
    private TextOffsetField endOffsetField;

    public IA2TextTextMethod(AccessibleText accessibleText) {
        super("text", true);
        this.accessibleText = accessibleText;
        int n = accessibleText.getCharacterCount();
        this.startOffsetField = new TextOffsetField("startOffset", 0, accessibleText);
        this.endOffsetField = new TextOffsetField("endOffset", n, accessibleText);
        this.setInputFields(new AbstractInputField[]{this.startOffsetField, this.endOffsetField});
    }

    public Object getResult() {
        int n = this.startOffsetField.getIntValue();
        int n2 = this.endOffsetField.getIntValue();
        String string = this.accessibleText.getTextRange(n, n2);
        return this.formatResult("text=" + IA2TextTextMethod.T(string));
    }
}

