/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.accessibility.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.PresentationElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.office.TextElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.util.accessibility.ScreenReaderSimulator;
import org.eclipse.actf.model.dom.odf.util.converter.impl.TextExtractorImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScreenReaderSimulatorImpl
implements ScreenReaderSimulator {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private ODFElement curElem = null;
    private TextExtractorImpl textExtractor = new TextExtractorImpl();

    public void setDocument(ODFDocument oDFDocument) {
        this.curElem = (ODFElement)oDFDocument.getDocumentElement();
        this.textExtractor.setDocument(oDFDocument, this);
    }

    public void setElement(ODFElement oDFElement) {
        this.curElem = oDFElement;
        this.textExtractor.setDocument((ODFDocument)oDFElement.getOwnerDocument(), this);
    }

    public void setOdfVersion(double d) {
        this.textExtractor.setOdfVersion(d);
    }

    private void writePageElementContent(Writer writer, PageElement pageElement) {
        List<ODFElement> list = pageElement.getChildNodesInNavOrder();
        int n = 0;
        while (n < list.size()) {
            String string;
            Node node = list.get(n);
            if (node instanceof ODFElement && !(node instanceof NotesElement) && (string = this.getElementContent((ODFElement)node)) != null) {
                try {
                    writer.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ++n;
        }
    }

    public boolean extractContent(Writer writer, File file, ODFElement oDFElement, boolean bl) {
        return this.textExtractor.extractContent(writer, file, oDFElement, bl);
    }

    public String getElementContent(ODFElement oDFElement) {
        this.setElement(oDFElement);
        StringWriter stringWriter = new StringWriter();
        if (oDFElement instanceof PageElement) {
            this.writePageElementContent(stringWriter, (PageElement)oDFElement);
        } else {
            this.extractContent(stringWriter, null, oDFElement, false);
        }
        String string = "";
        try {
            stringWriter.flush();
            stringWriter.close();
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public String getCurrentElementContent() {
        return this.getElementContent(this.curElem);
    }

    private String getTextDocumentContent(TextElement textElement) {
        StringWriter stringWriter = new StringWriter();
        Object object = textElement.getChildIterator();
        while (object.hasNext()) {
            String string;
            Element element = object.next();
            if (!(element instanceof ODFElement) || (string = this.getElementContent((ODFElement)element)) == null) continue;
            stringWriter.write(string);
        }
        object = "";
        try {
            stringWriter.flush();
            stringWriter.close();
            object = stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    private String getSpreadsheetDocumentContent(SpreadSheetElement spreadSheetElement) {
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        while ((long)n < spreadSheetElement.getTableSize()) {
            TableElement tableElement = spreadSheetElement.getTable(n);
            String string = this.getElementContent(tableElement);
            if (string != null) {
                stringWriter.write(String.valueOf(string) + LINE_SEP);
            }
            ++n;
        }
        String string = "";
        try {
            stringWriter.flush();
            stringWriter.close();
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    private String getPresentationDocumentContent(PresentationElement presentationElement) {
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        while ((long)n < presentationElement.getPageSize()) {
            PageElement pageElement = presentationElement.getPage(n);
            NotesElement notesElement = pageElement.getPresentationNotesElement();
            stringWriter.write("Page ");
            stringWriter.write(n + 1);
            stringWriter.write(LINE_SEP);
            stringWriter.write(this.getElementContent(pageElement));
            stringWriter.write(LINE_SEP);
            stringWriter.write("--------------------------------------");
            stringWriter.write(LINE_SEP);
            stringWriter.write("Speaker Notes");
            stringWriter.write(LINE_SEP);
            stringWriter.write(this.getElementContent(notesElement));
            ++n;
        }
        String string = "";
        try {
            stringWriter.flush();
            stringWriter.close();
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public String getDocumentContent() {
        if (this.curElem == null) {
            return null;
        }
        Element element = this.curElem.getOwnerDocument().getDocumentElement();
        if (element instanceof DocumentContentElement) {
            BodyElement bodyElement = ((DocumentContentElement)element).getBodyElement();
            ContentBaseElement contentBaseElement = bodyElement.getContent();
            ODFConstants.ContentType contentType = contentBaseElement.getContentType();
            if (contentType.equals((Object)ODFConstants.ContentType.WRITE) && contentBaseElement instanceof TextElement) {
                return this.getTextDocumentContent((TextElement)contentBaseElement);
            }
            if (contentType.equals((Object)ODFConstants.ContentType.SPREADSHEET) && contentBaseElement instanceof SpreadSheetElement) {
                return this.getSpreadsheetDocumentContent((SpreadSheetElement)contentBaseElement);
            }
            if (contentType.equals((Object)ODFConstants.ContentType.PRESENTATION) && contentBaseElement instanceof PresentationElement) {
                return this.getPresentationDocumentContent((PresentationElement)contentBaseElement);
            }
            new ODFException("invalid content element").printStackTrace();
        } else {
            new ODFException("invalid odf document").printStackTrace();
        }
        return null;
    }
}

