/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.table.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.content.IStyleListener;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.range.impl.ITextElementContainerUtil;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TableRowElementImpl
extends ODFStylableElementImpl
implements TableRowElement {
    private static final long serialVersionUID = 4515268211599720829L;

    protected TableRowElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    @Override
    public String getAttrTableStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        }
        return null;
    }

    @Override
    public int getAttrTableNumberRowsRepeated() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated")) {
            return new Integer(this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated"));
        }
        return -1;
    }

    @Override
    public int getTableIndex() {
        TableElement tableElement = this.getTableElement();
        return tableElement.getTableIndex();
    }

    @Override
    public int getRowIndex() {
        TableElement tableElement = this.getTableElement();
        if (tableElement == null) {
            return -1;
        }
        NodeList nodeList = tableElement.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row");
        if (nodeList == null) {
            return -1;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).equals(this)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public TableElement getTableElement() {
        TableElement tableElement = null;
        Node node = this.getParentNode();
        while (node != null) {
            if (node instanceof TableElement) {
                tableElement = (TableElement)node;
                break;
            }
            node = node.getParentNode();
        }
        return tableElement;
    }

    @Override
    public List<TableCellElement> getTableCellChildren() {
        Vector<TableCellElement> vector = null;
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof TableCellElement) {
                if (vector == null) {
                    vector = new Vector<TableCellElement>();
                }
                vector.add((TableCellElement)nodeList.item(n));
            }
            ++n;
        }
        return vector;
    }

    @Override
    public void setStyle(StyleElement styleElement) {
    }

    @Override
    public StyleElement getStyle() {
        return null;
    }

    @Override
    public void addStyleListener(IStyleListener iStyleListener, String string) {
    }

    @Override
    public void removeStyleListener(IStyleListener iStyleListener, String string) {
    }

    @Override
    public long getContentSize() {
        return ITextElementContainerUtil.getContentSize(this);
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return ITextElementContainerUtil.getChildIterator(this);
    }
}

