/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleRelation;
import org.eclipse.actf.accservice.swtbridge.internal.InternalAccessibleObject;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleRelation;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;

public class InternalAccessibleRelation
implements AccessibleRelation {
    private IAccessibleRelation accessibleRelation = null;

    public InternalAccessibleRelation(int n) {
        this.accessibleRelation = new IAccessibleRelation(n);
        this.accessibleRelation.AddRef();
    }

    public void dispose() {
        if (this.accessibleRelation != null) {
            this.accessibleRelation.Release();
            this.accessibleRelation = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getRelationType() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.accessibleRelation.get_relationType(nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return null;
    }

    public String getLocalizedRelationType() {
        NativeStringAccess nativeStringAccess = new NativeStringAccess();
        try {
            if (this.accessibleRelation.get_localizedRelationType(nativeStringAccess.getAddress()) == 0) {
                String string = nativeStringAccess.getString();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeStringAccess.dispose();
        }
        return null;
    }

    public int getTargetCount() {
        NativeIntAccess nativeIntAccess = new NativeIntAccess();
        try {
            if (this.accessibleRelation.get_nTargets(nativeIntAccess.getAddress()) == 0) {
                int n = nativeIntAccess.getInt();
                return n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeIntAccess.dispose();
        }
        return 0;
    }

    public AccessibleObject getTarget(int n) {
        NativeIntAccess nativeIntAccess = new NativeIntAccess();
        try {
            if (this.accessibleRelation.get_target(n, nativeIntAccess.getAddress()) == 0) {
                AccessibleObject accessibleObject = InternalAccessibleObject.newInstance(nativeIntAccess.getInt());
                return accessibleObject;
            }
        }
        catch (Exception exception) {
        }
        finally {
            nativeIntAccess.dispose();
        }
        return null;
    }

    public AccessibleObject[] getTargets(int n) {
        if (n > 0) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(n + 1);
            try {
                if (this.accessibleRelation.get_targets(n, nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(0)) == 0) {
                    int n2 = nativeIntAccess.getInt();
                    AccessibleObject[] accessibleObjectArray = new AccessibleObject[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        accessibleObjectArray[n3] = InternalAccessibleObject.newInstance(nativeIntAccess.getInt(n3 + 1));
                        ++n3;
                    }
                    AccessibleObject[] accessibleObjectArray2 = accessibleObjectArray;
                    return accessibleObjectArray2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }
}

