/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.visualization.google.json;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

public class JSONGoogleDataTable {
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATETIME = "datetime";
    public static final String TYPE_TIMEOFDAY = "timeofday";
    private static final String JSON_NAME_COLUMNS = "cols";
    private static final String JSON_NAME_COLUMNS_ID = "id";
    private static final String JSON_NAME_COLUMNS_LABEL = "label";
    private static final String JSON_NAME_COLUMNS_TYPE = "type";
    private static final String JSON_NAME_COLUMNS_PATTERN = "pattern";
    private static final String JSON_NAME_ROWS = "rows";
    private static final String JSON_NAME_ROWS_V = "v";
    private static final String JSON_NAME_ROWS_F = "f";
    private JSONArray columns;
    private JSONArray rows;

    public JSONObject createTable() {
        JSONObject table = new JSONObject();
        try {
            if (this.columns != null) {
                table.put(JSON_NAME_COLUMNS, (Object)this.columns);
            }
            if (this.rows != null) {
                table.put(JSON_NAME_ROWS, (Object)this.rows);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return table;
    }

    private JSONObject createCell(Object v, String f) throws JSONException {
        JSONObject cell = new JSONObject();
        cell.put(JSON_NAME_ROWS_V, v);
        if (f != null) {
            cell.put(JSON_NAME_ROWS_F, (Object)f);
        }
        return cell;
    }

    public void addColumn(String id, String label, String type, String pattern) {
        JSONObject column = new JSONObject();
        try {
            column.put(JSON_NAME_COLUMNS_ID, (Object)id);
            if (label != null) {
                column.put(JSON_NAME_COLUMNS_LABEL, (Object)label);
            }
            column.put(JSON_NAME_COLUMNS_TYPE, (Object)type);
            column.put(JSON_NAME_COLUMNS_PATTERN, (Object)pattern);
        }
        catch (Exception exception) {}
        if (this.columns == null) {
            this.columns = new JSONArray();
        }
        this.columns.put((Object)column);
    }

    public void addRow(Object[] row) {
        this.addRow(row, false);
    }

    public void addRow(Object[] row, boolean hasFormattedValues) {
        JSONArray rowArray = new JSONArray();
        JSONObject rowObj = new JSONObject();
        int i = 0;
        while (i < row.length) {
            Object v = row[i];
            Object f = null;
            if (hasFormattedValues && i + 1 < row.length) {
                f = row[i + 1];
                ++i;
            }
            JSONObject cell = null;
            try {
                cell = f == null ? this.createCell(v, null) : this.createCell(v, String.valueOf(f));
            }
            catch (Exception exception) {}
            rowArray.put(cell);
            ++i;
        }
        try {
            rowObj.put("c", (Object)rowArray);
        }
        catch (Exception exception) {}
        if (this.rows == null) {
            this.rows = new JSONArray();
        }
        this.rows.put((Object)rowObj);
    }

    public String toString() {
        try {
            JSONObject table = this.createTable();
            Iterator keys = table.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONObject.quote((String)o.toString()));
                sb.append(':');
                sb.append(JSONGoogleDataTable.valueToString(table.get((String)o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException((Throwable)e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)((Number)value));
        }
        if (value instanceof JSONArray) {
            try {
                return String.valueOf('[') + JSONGoogleDataTable.join((JSONArray)value, ",") + ']';
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return JSONGoogleDataTable.jsonObjectToString((JSONObject)value);
        }
        if (value instanceof Date) {
            return JSONGoogleDataTable.dateToString((Date)value);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote((String)value.toString());
    }

    private static String dateToString(Date d) throws JSONException {
        if (d == null) {
            throw new JSONException("Null pointer");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        String s = "new Date(";
        s = String.valueOf(s) + c.get(1) + ",";
        s = String.valueOf(s) + c.get(2) + ",";
        s = String.valueOf(s) + c.get(5) + ",";
        s = String.valueOf(s) + c.get(11) + ",";
        s = String.valueOf(s) + c.get(12) + ",";
        s = String.valueOf(s) + c.get(13);
        s = String.valueOf(s) + ")";
        return s;
    }

    private static String jsonObjectToString(JSONObject jObj) {
        try {
            Iterator keys = jObj.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONObject.quote((String)o.toString()));
                sb.append(':');
                sb.append(JSONGoogleDataTable.valueToString(jObj.get((String)o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String join(JSONArray arr, String separator) throws JSONException {
        int len = arr.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONGoogleDataTable.valueToString(arr.get(i)));
            ++i;
        }
        return sb.toString();
    }
}

