/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.identity;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;

public class ServiceID
extends BaseID
implements IServiceID {
    private static final long serialVersionUID = 4362768703249025783L;
    protected IServiceInfo serviceInfo;
    protected IServiceTypeID type;
    protected URI location;

    protected ServiceID(Namespace namespace, IServiceTypeID type, URI anURI) {
        super(namespace);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)anURI);
        this.type = type;
        this.location = anURI;
    }

    protected String getFullyQualifiedName() {
        return String.valueOf(this.type.getName()) + "@" + this.location;
    }

    protected int namespaceCompareTo(BaseID o) {
        if (o instanceof ServiceID) {
            ServiceID other = (ServiceID)o;
            String typename = other.getFullyQualifiedName();
            return this.getFullyQualifiedName().compareTo(typename);
        }
        return 1;
    }

    protected boolean namespaceEquals(BaseID o) {
        ServiceID other;
        if (o == null) {
            return false;
        }
        return o instanceof ServiceID && (other = (ServiceID)o).getName().equals(this.getName());
    }

    protected String namespaceGetName() {
        return this.getFullyQualifiedName();
    }

    protected int namespaceHashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public String getServiceType() {
        return this.type.getName();
    }

    public IServiceTypeID getServiceTypeID() {
        return this.type;
    }

    public String getServiceName() {
        return this.serviceInfo.getServiceName();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceID[");
        buf.append("type=").append(this.type).append(";location=").append(this.getLocation()).append(";full=" + this.getFullyQualifiedName()).append("]");
        return buf.toString();
    }

    public URI getLocation() {
        return this.location;
    }

    public IServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public void setServiceInfo(IServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceID other = (ServiceID)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

