/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.dialogs;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.oomph.internal.version.IVersionBuilderArguments;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationDialog
extends TitleAreaDialog
implements IVersionBuilderArguments {
    private static final String PATH_LABEL = "Path to release specification file";
    private static final String BUILDER_CONFIGURATION = "Version Builder Configuration";
    private VersionBuilderArguments values;
    private Text releasePathText;
    private Button ignoreMalformedVersionsButton;
    private Button ignoreFeatureNatureButton;
    private Button ignoreSchemaBuilderButton;
    private Button ignoreDebugOptionsButton;
    private Button ignoreMissingDependencyRangesButton;
    private Button ignoreLaxLowerBoundDependencyButton;
    private Button ignoreMissingExportVersionsButton;
    private Button ignoreFeatureContentChangesButton;
    private Button ignoreFeatureContentRedundancyButton;
    private Button checkFeatureClosureCompletenessButton;
    private Button checkFeatureClosureContentButton;
    private Button checkMavenPomButton;

    public ConfigurationDialog(Shell parentShell, VersionBuilderArguments defaults) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.values = new VersionBuilderArguments((Map)defaults);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(BUILDER_CONFIGURATION);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(BUILDER_CONFIGURATION);
        this.setMessage("Select a release specification file and check additional settings.");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        new Label(composite, 0).setText("Path to release specification file: ");
        this.releasePathText = new Text(composite, 2048);
        this.releasePathText.setLayoutData((Object)new GridData(768));
        String releasePath = this.values.getReleasePath();
        if (releasePath != null) {
            this.releasePathText.setText(releasePath);
        }
        this.releasePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigurationDialog.this.validate();
            }
        });
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.validate();
            }
        };
        this.ignoreMalformedVersionsButton = new Button(composite, 32);
        this.ignoreMalformedVersionsButton.setText("Ignore malformed versions");
        this.ignoreMalformedVersionsButton.setSelection(this.values.isIgnoreMalformedVersions());
        this.ignoreMalformedVersionsButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreFeatureNatureButton = new Button(composite, 32);
        this.ignoreFeatureNatureButton.setText("Ignore feature nature");
        this.ignoreFeatureNatureButton.setSelection(this.values.isIgnoreFeatureNature());
        this.ignoreFeatureNatureButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreSchemaBuilderButton = new Button(composite, 32);
        this.ignoreSchemaBuilderButton.setText("Ignore schema builder");
        this.ignoreSchemaBuilderButton.setSelection(this.values.isIgnoreSchemaBuilder());
        this.ignoreSchemaBuilderButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreDebugOptionsButton = new Button(composite, 32);
        this.ignoreDebugOptionsButton.setText("Ignore debug options");
        this.ignoreDebugOptionsButton.setSelection(this.values.isIgnoreDebugOptions());
        this.ignoreDebugOptionsButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreMissingDependencyRangesButton = new Button(composite, 32);
        this.ignoreMissingDependencyRangesButton.setText("Ignore missing dependency version ranges");
        this.ignoreMissingDependencyRangesButton.setSelection(this.values.isIgnoreMissingDependencyRanges());
        this.ignoreMissingDependencyRangesButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreLaxLowerBoundDependencyButton = new Button(composite, 32);
        this.ignoreLaxLowerBoundDependencyButton.setText("Ignore lax lower bound dependency versions");
        this.ignoreLaxLowerBoundDependencyButton.setSelection(this.values.isIgnoreLaxLowerBoundDependencyVersions());
        this.ignoreLaxLowerBoundDependencyButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreMissingExportVersionsButton = new Button(composite, 32);
        this.ignoreMissingExportVersionsButton.setText("Ignore missing package export versions");
        this.ignoreMissingExportVersionsButton.setSelection(this.values.isIgnoreMissingExportVersions());
        this.ignoreMissingExportVersionsButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreFeatureContentChangesButton = new Button(composite, 32);
        this.ignoreFeatureContentChangesButton.setText("Ignore feature content changes");
        this.ignoreFeatureContentChangesButton.setSelection(this.values.isIgnoreFeatureContentChanges());
        this.ignoreFeatureContentChangesButton.addSelectionListener((SelectionListener)buttonListener);
        this.ignoreFeatureContentRedundancyButton = new Button(composite, 32);
        this.ignoreFeatureContentRedundancyButton.setText("Ignore feature content redundancy");
        this.ignoreFeatureContentRedundancyButton.setSelection(this.values.isIgnoreFeatureContentRedundancy());
        this.ignoreFeatureContentRedundancyButton.addSelectionListener((SelectionListener)buttonListener);
        this.checkFeatureClosureCompletenessButton = new Button(composite, 32);
        this.checkFeatureClosureCompletenessButton.setText("Check feature closure completeness");
        this.checkFeatureClosureCompletenessButton.setSelection(this.values.isCheckFeatureClosureCompleteness());
        this.checkFeatureClosureCompletenessButton.addSelectionListener((SelectionListener)buttonListener);
        this.checkFeatureClosureContentButton = new Button(composite, 32);
        this.checkFeatureClosureContentButton.setText("Check feature closure content");
        this.checkFeatureClosureContentButton.setSelection(this.values.isCheckFeatureClosureContent());
        this.checkFeatureClosureContentButton.addSelectionListener((SelectionListener)buttonListener);
        this.checkMavenPomButton = new Button(composite, 32);
        this.checkMavenPomButton.setText("Check Maven POM");
        this.checkMavenPomButton.setSelection(this.values.isCheckMavenPom());
        this.checkMavenPomButton.addSelectionListener((SelectionListener)buttonListener);
        this.validate();
        return dialogArea;
    }

    protected void validate() {
        if (this.releasePathText.getText().trim().length() == 0) {
            this.setErrorMessage("Path to release specification file is empty.");
            return;
        }
        boolean redundancyCheck = !this.ignoreFeatureContentRedundancyButton.getSelection();
        boolean completenessCheck = this.checkFeatureClosureCompletenessButton.getSelection();
        if (redundancyCheck && completenessCheck) {
            this.setErrorMessage("Redundancy and completeness checks cannot be done at the same time.");
            return;
        }
        this.setErrorMessage(null);
    }

    protected void okPressed() {
        this.values.setReleasePath(this.releasePathText.getText());
        this.values.setIgnoreMalformedVersions(this.ignoreMalformedVersionsButton.getSelection());
        this.values.setIgnoreFeatureNature(this.ignoreFeatureNatureButton.getSelection());
        this.values.setIgnoreSchemaBuilder(this.ignoreSchemaBuilderButton.getSelection());
        this.values.setIgnoreDebugOptions(this.ignoreDebugOptionsButton.getSelection());
        this.values.setIgnoreMissingDependencyRanges(this.ignoreMissingDependencyRangesButton.getSelection());
        this.values.setIgnoreLaxLowerBoundDependencyVersions(this.ignoreLaxLowerBoundDependencyButton.getSelection());
        this.values.setIgnoreMissingExportVersions(this.ignoreMissingExportVersionsButton.getSelection());
        this.values.setIgnoreFeatureContentChanges(this.ignoreFeatureContentChangesButton.getSelection());
        this.values.setIgnoreFeatureContentRedundancy(this.ignoreFeatureContentRedundancyButton.getSelection());
        this.values.setCheckFeatureClosureCompleteness(this.checkFeatureClosureCompletenessButton.getSelection());
        this.values.setCheckFeatureClosureContent(this.checkFeatureClosureContentButton.getSelection());
        this.values.setCheckMavenPom(this.checkMavenPomButton.getSelection());
        super.okPressed();
    }

    public String getReleasePath() {
        return this.values.getReleasePath();
    }

    public String getValidatorClassName() {
        return this.values.getValidatorClassName();
    }

    public boolean isIgnoreMalformedVersions() {
        return this.values.isIgnoreMalformedVersions();
    }

    public boolean isIgnoreFeatureNature() {
        return this.values.isIgnoreFeatureNature();
    }

    public boolean isIgnoreSchemaBuilder() {
        return this.values.isIgnoreSchemaBuilder();
    }

    public boolean isIgnoreDebugOptions() {
        return this.values.isIgnoreDebugOptions();
    }

    public boolean isIgnoreMissingDependencyRanges() {
        return this.values.isIgnoreMissingDependencyRanges();
    }

    public boolean isIgnoreLaxLowerBoundDependencyVersions() {
        return this.values.isIgnoreLaxLowerBoundDependencyVersions();
    }

    public boolean isIgnoreMissingExportVersions() {
        return this.values.isIgnoreMissingExportVersions();
    }

    public boolean isIgnoreFeatureContentChanges() {
        return this.values.isIgnoreFeatureContentChanges();
    }

    public boolean isIgnoreFeatureContentRedundancy() {
        return this.values.isIgnoreFeatureContentRedundancy();
    }

    public boolean isCheckFeatureClosureCompleteness() {
        return this.values.isCheckFeatureClosureCompleteness();
    }

    public boolean isCheckFeatureClosureContent() {
        return this.values.isCheckFeatureClosureContent();
    }

    public boolean isCheckMavenPom() {
        return this.values.isCheckMavenPom();
    }

    public void applyTo(IProject project) throws CoreException {
        this.values.applyTo(project);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String get(Object key) {
        return (String)this.values.get(key);
    }

    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    public String put(String key, String value) {
        return (String)this.values.put((Object)key, (Object)value);
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        this.values.putAll(m);
    }

    public String remove(Object key) {
        return (String)this.values.remove(key);
    }

    public void clear() {
        this.values.clear();
    }

    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public Collection<String> values() {
        return this.values.values();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.values.entrySet();
    }

    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

