/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstraintType implements Enumerator
{
    VALID_RELATIVE_PARENT(0, "ValidRelativeParent", "ValidRelativeParent"),
    RESOLVES_IN_REALM(1, "ResolvesInRealm", "ResolvesInRealm");

    public static final int VALID_RELATIVE_PARENT_VALUE = 0;
    public static final int RESOLVES_IN_REALM_VALUE = 1;
    private static final ConstraintType[] VALUES_ARRAY;
    public static final List<ConstraintType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstraintType[]{VALID_RELATIVE_PARENT, RESOLVES_IN_REALM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstraintType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintType get(int value) {
        switch (value) {
            case 0: {
                return VALID_RELATIVE_PARENT;
            }
            case 1: {
                return RESOLVES_IN_REALM;
            }
        }
        return null;
    }

    private ConstraintType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

