/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IElementResolver;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.pde.core.IModel;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
implements IElement {
    private IElement.Type type;
    private String name;
    private Version version;
    private boolean licenseFeature;
    private List<IElement> children = new ArrayList<IElement>();
    private Set<IElement> allChildren;

    public Element(IElement.Type type, String name, Version version) {
        this.type = type;
        this.name = name;
        this.version = VersionUtil.normalize(version);
    }

    public Element(IElement.Type type, String name, String version) {
        this(type, name, new Version(version));
    }

    public Element(IElement.Type type, String name) {
        this.type = type;
        this.name = name;
        this.version = Version.emptyVersion;
    }

    @Override
    public IElement.Type getType() {
        return this.type;
    }

    @Override
    public String getTag() {
        return this.type == IElement.Type.PLUGIN ? "plugin" : "feature";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean isLicenseFeature() {
        return this.licenseFeature;
    }

    public void setLicenseFeature(boolean licenseFeature) {
        this.licenseFeature = licenseFeature;
    }

    @Override
    public List<IElement> getChildren() {
        return this.children;
    }

    @Override
    public Set<IElement> getAllChildren(IElementResolver resolver, IElementResolver otherResolver) {
        if (this.allChildren == null) {
            this.allChildren = new HashSet<IElement>();
            for (IElement child : this.children) {
                this.recurseChildren(resolver, otherResolver, child);
            }
        }
        return this.allChildren;
    }

    private void recurseChildren(IElementResolver resolver, IElementResolver otherResolver, IElement element) {
        if (this.allChildren.add(element)) {
            IElement topElement = resolver.resolveElement(element);
            if (topElement == null && (topElement = resolver.resolveElement(element.trimVersion())) == null) {
                return;
            }
            IElement otherTopElement = otherResolver.resolveElement(element);
            if (otherTopElement == null && (otherTopElement = resolver.resolveElement(element.trimVersion())) == null) {
                return;
            }
            if (otherTopElement.isVersionUnresolved()) {
                return;
            }
            for (IElement child : topElement.getChildren()) {
                if (child.isLicenseFeature()) continue;
                this.recurseChildren(resolver, otherResolver, child);
            }
        }
    }

    @Override
    public IElement getChild(IElementResolver resolver, IElementResolver otherResolver, IElement key) {
        Set<IElement> allChildren = this.getAllChildren(resolver, otherResolver);
        for (IElement child : allChildren) {
            if (!child.equals(key)) continue;
            return child;
        }
        return null;
    }

    public String toString() {
        return "Element[type=" + (Object)((Object)this.type) + ", name=" + this.name + ", version=" + this.version + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.version.equals((Object)Version.emptyVersion) || other.getVersion().equals((Object)Version.emptyVersion) || this.version.equals((Object)other.getVersion());
    }

    @Override
    public IElement trimVersion() {
        return new Element(this.type, this.name);
    }

    @Override
    public boolean isVersionUnresolved() {
        return this.version.equals((Object)Version.emptyVersion);
    }

    void resolveVersion() {
        this.version = this.getResolvedVersion();
    }

    @Override
    public Version getResolvedVersion() {
        IModel componentModel;
        if (this.isVersionUnresolved() && (componentModel = IReleaseManager.INSTANCE.getComponentModel(this)) != null) {
            return VersionUtil.getComponentVersion(componentModel);
        }
        return this.version;
    }
}

