/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.workingsets.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.oomph.workingsets.InclusionPredicate;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsPackage;
import org.eclipse.oomph.workingsets.provider.ExclusionPredicateItemProvider;
import org.eclipse.oomph.workingsets.provider.WorkingSetsEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InclusionPredicateItemProvider
extends PredicateItemProvider {
    public InclusionPredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIncludedWorkingSetsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIncludedWorkingSetsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_InclusionPredicate_includedWorkingSets_feature"), this.getString("_UI_InclusionPredicate_includedWorkingSets_description"), (EStructuralFeature)WorkingSetsPackage.Literals.INCLUSION_PREDICATE__INCLUDED_WORKING_SETS, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection result = super.getChoiceOfValues(object);
                ExclusionPredicateItemProvider.filterCircularWorkingSets((EObject)object, result);
                return result;
            }
        });
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, true);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/InclusionPredicate"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        InclusionPredicate inclusionPredicate = (InclusionPredicate)object;
        StringBuilder result = new StringBuilder();
        for (WorkingSet workingSet : inclusionPredicate.getIncludedWorkingSets()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(workingSet.getName());
        }
        return result.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(InclusionPredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getFeature() == null) {
            EObject eOwner = commandParameter.getEOwner();
            ArrayList collection = commandParameter.getCollection();
            if (collection != null) {
                collection = new ArrayList(collection);
                ExclusionPredicateItemProvider.filterCircularWorkingSets(eOwner, collection);
                if (collection.size() == commandParameter.getCollection().size()) {
                    return new AddCommand(domain, commandParameter.getEOwner(), (EStructuralFeature)WorkingSetsPackage.Literals.INCLUSION_PREDICATE__INCLUDED_WORKING_SETS, commandParameter.getCollection());
                }
            }
        }
        return super.factorAddCommand(domain, commandParameter);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return WorkingSetsEditPlugin.INSTANCE;
    }
}

