/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.repository;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.oomph.gitbash.GitBash;
import org.eclipse.oomph.gitbash.repository.AbstractRepositoryAction;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitCopyrightsAction
extends AbstractRepositoryAction {
    private static final String[] IGNORED_PATHS = new String[]{"resourcemanager.java", "menucardtemplate.java", "org.eclipse.oomph.version.tests\\tests", "org.eclipse.net4j.jms.api"};
    private static final String[] REQUIRED_EXTENSIONS = new String[]{".java", ".ant", "build.xml", "plugin.xml", "fragment.xml", "feature.xml", "plugin.properties", "fragment.properties", "feature.properties", "about.properties", "build.properties", "messages.properties", "copyright.txt", ".exsd"};
    private static final String[] OPTIONAL_EXTENSIONS = new String[]{".properties", ".xml", ".html", ".ecore", ".genmodel"};
    private static final String[] IGNORED_MESSAGES = new String[]{"update copyrights", "updated copyrights", "adjust legal headers", "adjusted legal headers", "update legal headers", "updated legal headers", "adjust copyrights", "adjusted copyrights", "fix copyrights", "fixed copyrights", "fix legal headers", "fixed legal headers"};
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(.*?)Copyright \\(c\\) ([0-9 ,-]+) (.*?) and others.(.*)");
    private static final String BEGIN_COMMIT = "--BEGIN-COMMIT--";
    private static final String BEGIN_MESSAGE = "--BEGIN-SUMMARY--";
    private static final String OUTPUT_FORMAT = "--BEGIN-COMMIT--%n%ci%n%B%n--BEGIN-SUMMARY--%n";
    private static final String NL = System.getProperty("line.separator");
    private File workTree;
    private int workTreeLength;
    private List<String> missingCopyrights = new ArrayList<String>();
    private int rewriteCount;
    private File outFile;

    @Override
    protected void run(Shell shell, File workTree) throws Exception {
        try {
            this.workTree = workTree;
            this.workTreeLength = workTree.getAbsolutePath().length() + 1;
            this.checkFolder(shell, workTree);
            System.out.println("Missing count: " + this.missingCopyrights.size());
            System.out.println("Rewrite count: " + this.rewriteCount);
        }
        finally {
            this.missingCopyrights.clear();
            this.rewriteCount = 0;
            this.outFile = null;
        }
    }

    private void checkFolder(Shell shell, File folder) throws Exception {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isDirectory() && !fileName.equals(".git")) {
                this.checkFolder(shell, file);
            } else if (!fileName.equals(".gitlog")) {
                this.checkFile(shell, file);
            }
            ++n2;
        }
    }

    private void checkFile(Shell shell, File file) throws Exception {
        boolean optional;
        if (this.hasString(file.getPath(), IGNORED_PATHS)) {
            return;
        }
        boolean required = this.hasExtension(file, REQUIRED_EXTENSIONS);
        boolean bl = optional = required || this.hasExtension(file, OPTIONAL_EXTENSIONS);
        if (optional) {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String line;
                int lineNumber = 0;
                while ((line = bufferedReader.readLine()) != null) {
                    ++lineNumber;
                    Matcher matcher = COPYRIGHT_PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    String prefix = matcher.group(1);
                    String dates = matcher.group(1);
                    String owner = matcher.group(3);
                    String suffix = matcher.group(4);
                    this.rewriteFile(shell, file, lineNumber, prefix, dates, owner, suffix);
                    return;
                }
                if (required) {
                    String path = this.getPath(file);
                    this.missingCopyrights.add(path);
                    System.out.println("COPYRIGHT MISSING: " + path);
                }
            }
            finally {
                bufferedReader.close();
                fileReader.close();
            }
        }
    }

    private String getPath(File file) {
        String path = file.getAbsolutePath().replace('\\', '/');
        return path.substring(this.workTreeLength);
    }

    private boolean hasString(String string, String[] strings) {
        int i = 0;
        while (i < strings.length) {
            if (string.indexOf(strings[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasExtension(File file, String[] extensions) {
        String fileName = file.getName();
        int i = 0;
        while (i < extensions.length) {
            if (fileName.endsWith(extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void rewriteFile(Shell shell, File file, int copyrightLineNumber, String prefix, String dates, String owner, String suffix) throws Exception {
        String path = this.getPath(file);
        if (this.outFile == null) {
            this.outFile = File.createTempFile("git-", ".log");
        }
        try {
            GitBash.quiet = true;
            GitBash.executeCommand(shell, this.workTree, "git log --follow --name-only --format=\"--BEGIN-COMMIT--%n%ci%n%B%n--BEGIN-SUMMARY--%n\" -- \"" + path + "\" > \"/" + this.outFile.getAbsolutePath().replace(":", "").replace("\\", "/") + "\"");
        }
        finally {
            GitBash.quiet = false;
        }
        Set<Integer> years = this.parseOutFile();
        String newDates = this.formatYears(years);
        if (newDates.equals(dates)) {
            return;
        }
        ++this.rewriteCount;
        String copyrightLine = String.valueOf(prefix) + "Copyright (c) " + newDates + " " + owner + " and OTHERS." + suffix;
        System.out.println(String.valueOf(path) + ": " + newDates);
        List<String> lines = this.readLines(file);
        lines.set(copyrightLineNumber, copyrightLine);
        this.writeLines(file, lines);
    }

    private List<String> readLines(File file) throws FileNotFoundException, IOException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            this.close(bufferedReader);
            this.close(fileReader);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.close(bufferedReader);
            this.close(fileReader);
            throw throwable;
        }
    }

    private void writeLines(File file, List<String> lines) throws IOException {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.write(NL);
            }
        }
        catch (Throwable throwable) {
            this.close(bufferedWriter);
            this.close(fileWriter);
            throw throwable;
        }
        this.close(bufferedWriter);
        this.close(fileWriter);
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private String formatYears(Collection<Integer> years) {
        ArrayList<Integer> list = new ArrayList<Integer>(years);
        Collections.sort(list);
        class YearRange {
            private int begin;
            private int end;

            public YearRange(int begin) {
                this.begin = begin;
                this.end = begin;
            }

            public boolean add(int year) {
                if (year == this.end + 1) {
                    this.end = year;
                    return true;
                }
                return false;
            }

            public String toString() {
                if (this.begin == this.end) {
                    return "" + this.begin;
                }
                if (this.begin == this.end - 1) {
                    return this.begin + ", " + this.end;
                }
                return this.begin + "-" + this.end;
            }
        }
        ArrayList<YearRange> ranges = new ArrayList<YearRange>();
        YearRange lastRange = null;
        for (Integer year : list) {
            if (lastRange != null && lastRange.add(year)) continue;
            lastRange = new YearRange(year);
            ranges.add(lastRange);
        }
        StringBuilder builder = new StringBuilder();
        for (YearRange range : ranges) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(range);
        }
        return builder.toString();
    }

    private Set<Integer> parseOutFile() throws Exception {
        HashSet<Integer> years = new HashSet<Integer>();
        FileReader fileReader = new FileReader(this.outFile);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String line = bufferedReader.readLine();
            if (line != null) {
                if (!line.equals(BEGIN_COMMIT)) {
                    throw new IllegalStateException("Read unexpected line " + line + " at beginning of file " + this.outFile.getAbsolutePath());
                }
                block3: while (true) {
                    String date = this.readLineSafe(bufferedReader);
                    LogEntry logEntry = new LogEntry(date);
                    StringBuilder builder = new StringBuilder();
                    while (!(line = this.readLineSafe(bufferedReader)).equals(BEGIN_MESSAGE)) {
                        builder.append(line);
                        builder.append("\n");
                    }
                    logEntry.setMessage(builder.toString());
                    while (true) {
                        if ((line = bufferedReader.readLine()) == null) {
                            this.handleLogEntry(years, logEntry);
                            break block3;
                        }
                        if (line.equals(BEGIN_COMMIT)) {
                            this.handleLogEntry(years, logEntry);
                            continue block3;
                        }
                        if (line.trim().length() != 0) continue;
                    }
                    break;
                }
            }
            HashSet<Integer> hashSet = years;
            return hashSet;
        }
        finally {
            bufferedReader.close();
            fileReader.close();
            this.outFile.delete();
        }
    }

    private String readLineSafe(BufferedReader bufferedReader) throws IOException {
        String result = bufferedReader.readLine();
        if (result == null) {
            throw new IllegalStateException("Unexpected end of stream");
        }
        return result;
    }

    private void handleLogEntry(Set<Integer> years, LogEntry logEntry) {
        String message = logEntry.getMessage().toLowerCase();
        if (this.hasString(message, IGNORED_MESSAGES)) {
            return;
        }
        int year = Integer.parseInt(logEntry.getDate().substring(0, 4));
        years.add(year);
    }

    public static class LogEntry {
        private String date;
        private String message;

        public LogEntry(String date) {
            this.date = date;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

