/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil {
    public static final String EMPTY = "";
    public static final String NL = PropertiesUtil.getProperty("line.separator");
    public static String HORIZONTAL_ELLIPSIS = "\u2026";

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String safe(String str) {
        return StringUtil.safe(str, EMPTY);
    }

    private static String safe(String str, String def) {
        if (str == null) {
            return def;
        }
        return str;
    }

    public static String cap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isUpperCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toUpperCase(first));
        return builder.toString();
    }

    public static String capAll(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean inWhiteSpace = true;
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            boolean isWhiteSpace = Character.isWhitespace(c);
            if (!isWhiteSpace && inWhiteSpace) {
                builder.setCharAt(i, Character.toUpperCase(c));
            }
            inWhiteSpace = isWhiteSpace;
            ++i;
        }
        return builder.toString();
    }

    public static String uncap(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (Character.isLowerCase(first)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toLowerCase(first));
        return builder.toString();
    }

    public static String uncapAll(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        boolean inWhiteSpace = true;
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            boolean isWhiteSpace = Character.isWhitespace(c);
            if (!isWhiteSpace && inWhiteSpace) {
                builder.setCharAt(i, Character.toLowerCase(c));
            }
            inWhiteSpace = isWhiteSpace;
            ++i;
        }
        return builder.toString();
    }

    public static List<String> explode(String string, String separators) {
        return StringUtil.explode(string, separators, '\\');
    }

    public static List<String> explode(String string, String separators, char escapeCharacter) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean separator = false;
        boolean escape = false;
        int i = 0;
        while (i < string.length()) {
            separator = false;
            char c = string.charAt(i);
            if (!escape && c == escapeCharacter) {
                escape = true;
            } else {
                if (!escape && separators.indexOf(c) != -1) {
                    tokens.add(builder.toString());
                    builder.setLength(0);
                    separator = true;
                } else {
                    builder.append(c);
                }
                escape = false;
            }
            ++i;
        }
        if (separator || builder.length() != 0) {
            tokens.add(builder.toString());
        }
        return tokens;
    }

    public static String implode(List<String> tokens, char separator) {
        return StringUtil.implode(tokens, separator, '\\');
    }

    public static String implode(List<String> tokens, char separator, char escapeCharacter) {
        String escapeString = Character.toString(escapeCharacter);
        String escapeString2 = String.valueOf(escapeString) + escapeString;
        String separatorString = Character.toString(separator);
        String separatorString2 = String.valueOf(escapeString) + separatorString;
        StringBuilder builder = new StringBuilder();
        boolean firstTime = true;
        for (String token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                builder.append(separator);
            }
            if (token == null) continue;
            token = token.replace(escapeString, escapeString2);
            token = token.replace(separatorString, separatorString2);
            builder.append(token);
        }
        return builder.toString();
    }

    public static String toOSString(String uri) {
        URI emfURI;
        if (!StringUtil.isEmpty(uri) && (emfURI = URI.createURI((String)uri)).isFile()) {
            uri = emfURI.toFileString();
        }
        return uri;
    }

    public static String shorten(String input, int length, boolean wholeWord) {
        if (input == null) {
            return EMPTY;
        }
        if (length <= HORIZONTAL_ELLIPSIS.length()) {
            throw new IllegalArgumentException("Length must at least " + HORIZONTAL_ELLIPSIS.length() + 1);
        }
        if (input.length() <= length) {
            return input;
        }
        int ellipsisPos = length - HORIZONTAL_ELLIPSIS.length() - 1;
        if (wholeWord) {
            ellipsisPos = StringUtil.findLastSpaceBetween(input, 0, ellipsisPos);
        }
        String result = input.substring(0, ellipsisPos);
        result = String.valueOf(result) + HORIZONTAL_ELLIPSIS;
        return result;
    }

    public static String wrapText(String input, int maxCharactersPerLine, boolean wholeWord) {
        int startIndex = 0;
        int endIndex = startIndex + maxCharactersPerLine;
        boolean finished = false;
        StringBuilder builder = new StringBuilder();
        do {
            if (endIndex >= input.length()) {
                endIndex = input.length();
                finished = true;
            }
            if (!finished && wholeWord) {
                int spaceIndex = StringUtil.findLastSpaceBetween(input, startIndex, endIndex);
                if (spaceIndex > 0) {
                    endIndex = spaceIndex;
                } else {
                    endIndex = input.length();
                    finished = true;
                }
            }
            builder.append(input.substring(startIndex, endIndex));
            if (!finished) {
                builder.append(NL);
            }
            startIndex = wholeWord ? endIndex + 1 : endIndex;
            endIndex += maxCharactersPerLine;
        } while (!finished);
        return builder.toString();
    }

    private static int findLastSpaceBetween(String text, int startPosition, int endPosition) {
        int index = endPosition;
        char lastBeforeEllipsis = text.charAt(index);
        while (lastBeforeEllipsis != ' ') {
            if (--index <= startPosition) {
                index = -1;
                break;
            }
            lastBeforeEllipsis = text.charAt(index);
        }
        return index;
    }
}

