/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFS.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */
package org.eclipse.eodm.vocabulary;

/**
 * The RDFS vocabulary. Refer to
 * http://www.w3.org/TR/2004/REC-rdf-schema-20040210/.
 */
public class RDFS {
    /** RDF schema namespace */
    public static final String NAMESPACE = "http://www.w3.org/2000/01/rdf-schema#";

    /** XML schema namespace */
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema#";

    /** Balnk node namespace */
    public static final String BNODE_NAMESPACE = "http://bnode.ibm.com#";
    public static final String BNODE_SHORTNAME = "bnode";

    /**
     * The classes
     */
    public static final String C_RESOURCE = "Resource";

    public static final String C_CLASS = "Class";

    public static final String C_LITERAL = "Literal";

    public static final String C_DATATYPE = "Datatype";

    public static final String C_RESOURCE_STR = NAMESPACE + C_RESOURCE;

    public static final String C_CLASS_STR = NAMESPACE + C_CLASS;

    public static final String C_LITERAL_STR = NAMESPACE + C_LITERAL;

    public static final String C_DATATYPE_STR = NAMESPACE + C_DATATYPE;

    /**
     * The properties
     */
    public static final String P_RANGE = "range";

    public static final String P_DOMAIN = "domain";

    public static final String P_SUBCLASSOF = "subClassOf";

    public static final String P_SUBPROPERTYOF = "subPropertyOf";

    public static final String P_LABEL = "label";

    public static final String P_COMMENT = "comment";
    
    public static final String P_MEMBER = "member" ;

    public static final String P_RANGE_STR = NAMESPACE + P_RANGE;

    public static final String P_DOMAIN_STR = NAMESPACE + P_DOMAIN;

    public static final String P_SUBCLASSOF_STR = NAMESPACE + P_SUBCLASSOF;

    public static final String P_SUBPROPERTYOF_STR = NAMESPACE
                                                     + P_SUBPROPERTYOF;

    public static final String P_LABEL_STR = NAMESPACE + P_LABEL;

    public static final String P_COMMENT_STR = NAMESPACE + P_COMMENT;
    
    public static final String P_MEMBER_STR = NAMESPACE + P_MEMBER ;

    /**
     * Container classes and properties
     */
    public static final String CONTAINER = "Container";

    public static final String CONTAINERMEMBERSHIPPROPERTY = "ContainerMembershipProperty";

    public static final String MEMBER = "member";

    public static final String CONTAINER_STR = NAMESPACE + CONTAINER;

    public static final String CONTAINERMEMBERSHIPPROPERTY_STR = NAMESPACE
                                                                 + CONTAINERMEMBERSHIPPROPERTY;

    public static final String MEMBER_STR = NAMESPACE + MEMBER;

    /**
     * Utility properties
     */
    public static final String SEEALSO = "seeAlso";

    public static final String ISDEFINEDBY = "isDefinedBy";

    public static final String SEEALSO_STR = NAMESPACE + SEEALSO;

    public static final String ISDEFINEDBY_STR = NAMESPACE + ISDEFINEDBY;

    public static final String[] ALL_RDFS_PREDICATES_URIS = {
    		P_RANGE_STR, P_DOMAIN_STR, P_SUBCLASSOF_STR, P_SUBPROPERTYOF_STR, P_LABEL_STR,
			P_COMMENT_STR, P_MEMBER_STR, SEEALSO_STR, ISDEFINEDBY_STR
    };
}