/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLUtility.java,v 1.2 2007/03/18 10:23:39 lzhang Exp $
 */
package org.eclipse.eodm.util;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.HashMap;
import java.util.ArrayList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.impl.EODMImplPackage;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.*;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.vocabulary.OWL;
import org.eclipse.eodm.vocabulary.RDF;
import org.eclipse.eodm.vocabulary.RDFS;

public class OWLUtility {
	//The URIs of RDF predicate.
	public static String subclassof = RDFS.P_SUBCLASSOF_STR;
	public static String subproperyof = RDFS.P_SUBPROPERTYOF_STR;
	public static String domain = RDFS.P_DOMAIN_STR;
    public static String range = RDFS.P_RANGE_STR;    
    public static String comment = RDFS.P_COMMENT_STR;    
    public static String label = RDFS.P_LABEL_STR;    
    public static String seeAlso = RDFS.SEEALSO_STR;   
    public static String isDefinedBy = RDFS.ISDEFINEDBY_STR;    
    public static String member = RDFS.P_MEMBER_STR;    
    public static String type = RDF.P_TYPE_STR;    
    public static String subject = RDF.P_SUBJECT_STR;    
    public static String predicate = RDF.P_PREDICATE_STR;    
    public static String object = RDF.P_OBJECT_STR;    
    public static String value = RDF.P_VALUE_STR;    
    public static String first = RDF.P_FIRST_STR;    
    public static String rest = RDF.P_REST_STR;
    //The URIs of RDF Class
    public static String property = RDF.C_PROPERTY_STR;
    public static String statement = RDF.C_STATEMENT_STR;
    public static String resource = RDFS.C_RESOURCE_STR;
    public static String rdfsclass = RDFS.C_CLASS_STR;
    public static String container = RDFS.CONTAINER_STR;
    public static String containerMembershipProperty = RDFS.CONTAINERMEMBERSHIPPROPERTY_STR;
    public static String bag = RDF.C_BAG_STR;
    public static String alt = RDF.C_ALT_STR;
    public static String seq = RDF.C_SEQ_STR;
    public static String list = RDF.C_LIST_STR;
    public static String datatype = RDFS.C_DATATYPE_STR;
    
    
    //The URIs of OWL Class
    public static String owlclass = OWL.CLASS_URI;
    public static String owlontology = OWL.ONTOLOGY_URI;
    public static String ontologyproperty = OWL.ONTOLOGY_PROPERTY_URI;
    public static String objectproperty= OWL.OBJECT_PROPERTY_URI;
    public static String datatypeproperty= OWL.DATATYPE_PROPERTY_URI;
    public static String annotationproperty= OWL.ANNOTATION_PROPERTY_URI;
    public static String restriction = OWL.RESTRICTION_URI;
    public static String alldifferent = OWL.ALL_DIFFERENT_URI;
    public static String datarange = OWL.DATA_RANGE_URI;
    //The URIs of OWL predicate
    public static String allValuesFrom = OWL.ALL_VALUES_FROM_URI;
    public static String backwardCompatibleWith = OWL.BACKWARD_COMPATIBLE_WITH_URI;
    public static String cardinality = OWL.CARDINALITY_URI;
    public static String complementOf = OWL.COMPLEMENT_OF_URI;
    public static String differentFrom = OWL.DIFFERENT_FROM_URI;
    public static String disjointWith = OWL.DISJOINT_WITH_URI;
    public static String distinctMembers = OWL.DISTINCT_MEMBERS_URI;
    public static String equivalentClass = OWL.EQUIVALENT_CLASS_URI;
    public static String equivalentProperty = OWL.EQUIVALENT_PROPERTY_URI;
    public static String hasValue = OWL.HAS_VALUE_URI;
    public static String imports  = OWL.IMPORTS_URI;
    public static String incompatibleWith = OWL.INCOMPATIBLE_WITH_URI;
    public static String intersectionOf  = OWL.INTERSECTION_OF_URI;
    public static String inverseOf  = OWL.INVERSE_OF_URI;
    public static String maxCardinality  = OWL.MAX_CARDINALITY_URI;
    public static String minCardinality  = OWL.MIN_CARDINALITY_URI;
    public static String oneOf  = OWL.ONE_OF_URI;
    public static String onProperty  = OWL.ON_PROPERTY_URI;
    public static String priorVersion  = OWL.PRIOR_VERSION_URI;
    public static String sameAs  = OWL.SAME_AS_URI;
    public static String someValuesFrom   = OWL.SOME_VALUES_FROM_URI;
    public static String unionOf  = OWL.UNION_OF_URI;
    public static String versionInfo  = OWL.VERSION_INFO_URI;
    // speical predicates for ODM
    public static String allValuesFromClass = allValuesFrom + "class" ;
    public static String allValuesFromDatarange = allValuesFrom + "datarange" ;
    public static String someValuesFromClass = someValuesFrom + "class" ;
    public static String someValuesFromDatarange = someValuesFrom + "datarange";
    public static String hasValueLiteral = hasValue + "literal" ;
    public static String hasValueIndividual = hasValue + "individual" ;
    
    public static Namespace owl;
    public static URIReference owlclassRef;
    public static URIReference owlontologyRef;
    public static URIReference ontologypropertyRef;
    public static URIReference objectpropertyRef;
    public static URIReference datatypepropertyRef;
    public static URIReference annotationpropertyRef;
    public static URIReference restrictionRef;
    public static URIReference alldifferentRef;
    public static URIReference datarangeRef;
    
	public static HashSet SpecialProp = new HashSet( Arrays.asList( new String[] {
															OWL.OBJECT_PROPERTY_URI,
															OWL.DATATYPE_PROPERTY_URI,
															OWL.FUNCTIONAL_PROPERTY_URI,
															OWL.INVERSE_FUNCTIONAL_PROPERTY_URI,
															OWL.SYMMETRIC_PROPERTY_URI,
															OWL.TRANSITIVE_PROPERTY_URI }));

	public static HashSet SpecialValuePred = new HashSet( Arrays.asList( new String[] {
															OWL.HAS_VALUE_URI,
															OWL.ALL_VALUES_FROM_URI,
															OWL.SOME_VALUES_FROM_URI,
															OWL.ONE_OF_URI })); 

	public static HashSet SpecialSetPred = new HashSet ( Arrays.asList( new String[] {
															OWL.INTERSECTION_OF_URI,
															OWL.UNION_OF_URI,
															OWL.DISTINCT_MEMBERS_URI }));

	public static HashSet ExtendedValuePred = new HashSet( Arrays.asList( new String[] {
																allValuesFromClass, 
																allValuesFromDatarange,
																someValuesFromClass,
																someValuesFromDatarange,
																hasValueLiteral,
																hasValueIndividual
	}));
	
    //public static URIReference 
    static {
    	try{
	    	owl = RDFFactory.eINSTANCE.createNamespace(OWL.NAMESPACE_URI);
	    	owlclassRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.CLASS);
	    	owlontologyRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.ONTOLOGY);
	        ontologypropertyRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.ONTOLOGY_PROPERTY);;
	        objectpropertyRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.OBJECT_PROPERTY);;
	        datatypepropertyRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.DATATYPE_PROPERTY);;
	        annotationpropertyRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.ANNOTATION_PROPERTY);;
	        restrictionRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.RESTRICTION);;
	        alldifferentRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.ALL_DIFFERENT);;
	        datarangeRef = RDFFactory.eINSTANCE.createURIReference(owl,OWL.DATA_RANGE);;
    	}catch(Exception e){e.printStackTrace();}
    }
	
    static Random random = new Random();
    
	static HashMap eReferenceList = null;
	static HashMap featureIDList = null;
	static HashMap eClassList = null;
	static ArrayList predicateList = null;
	public static ArrayList getPredicates()
	{
		if(predicateList == null)
		{
			//add the rdf predicates to the arraylist
			predicateList = new ArrayList();
			predicateList.add(subclassof);
			predicateList.add(subproperyof);
			predicateList.add(domain);
			predicateList.add(range);
			predicateList.add(comment);
			predicateList.add(label);
			predicateList.add(seeAlso);
			predicateList.add(isDefinedBy);
			predicateList.add(member);
			predicateList.add(type);
			predicateList.add(subject);
			predicateList.add(predicate);
			predicateList.add(object);
			predicateList.add(value);
			predicateList.add(first);
			predicateList.add(rest);
			//add the owl predicates to the arraylist 
			predicateList.add(allValuesFromClass);
			predicateList.add(allValuesFromDatarange);
			predicateList.add(backwardCompatibleWith); 
			predicateList.add(cardinality); 
			predicateList.add(complementOf);
			predicateList.add(differentFrom);
			predicateList.add(disjointWith); 
			predicateList.add(distinctMembers); 
			predicateList.add(equivalentClass);
			predicateList.add(equivalentProperty);
			predicateList.add(hasValueIndividual);
			predicateList.add(hasValueLiteral);
			predicateList.add(imports);
			predicateList.add(incompatibleWith);
			predicateList.add(intersectionOf);
			predicateList.add(inverseOf); 
			predicateList.add(maxCardinality);
			predicateList.add(minCardinality); 
			predicateList.add(oneOf); 
			predicateList.add(onProperty);
			predicateList.add(priorVersion);
			predicateList.add(sameAs);
			predicateList.add(someValuesFromClass);
			predicateList.add(someValuesFromDatarange);
			predicateList.add(unionOf); 
			predicateList.add(versionInfo); 
		}
		return predicateList;
	}
	public static HashMap getEClass()
	{
		if(eClassList==null)
		{
			eClassList = new HashMap();
			eClassList.put(property,RDFBasePackage.eINSTANCE.getRDFProperty());
			eClassList.put(statement,RDFBasePackage.eINSTANCE.getRDFStatement());
			eClassList.put(resource,RDFBasePackage.eINSTANCE.getRDFSResource());
			eClassList.put(rdfsclass,RDFSPackage.eINSTANCE.getRDFSClass());
			eClassList.put(container,RDFSPackage.eINSTANCE.getRDFSContainer());
			eClassList.put(containerMembershipProperty,RDFSPackage.eINSTANCE.getRDFSContainerMembershipProperty());
			eClassList.put(bag,RDFSPackage.eINSTANCE.getRDFBag());
			eClassList.put(alt,RDFSPackage.eINSTANCE.getRDFAlt());
			eClassList.put(seq,RDFSPackage.eINSTANCE.getRDFSeq());
			eClassList.put(list,RDFSPackage.eINSTANCE.getRDFList());
			eClassList.put(datatype,RDFSPackage.eINSTANCE.getRDFSDatatype());
			
			eClassList.put(OWLUtility.owlclass,OWLBasePackage.eINSTANCE.getOWLClass());
			eClassList.put(OWLUtility.owlontology,OWLBasePackage.eINSTANCE.getOWLOntology());
			eClassList.put(OWLUtility.ontologyproperty,OWLBasePackage.eINSTANCE.getOWLOntologyProperty());
			eClassList.put(OWLUtility.objectproperty,OWLBasePackage.eINSTANCE.getOWLObjectProperty());
			eClassList.put(OWLUtility.datatypeproperty,OWLBasePackage.eINSTANCE.getOWLDatatypeProperty());
			eClassList.put(OWLUtility.restriction,OWLBasePackage.eINSTANCE.getOWLRestriction());
			eClassList.put(OWLUtility.annotationproperty,OWLBasePackage.eINSTANCE.getOWLAnnotationProperty());
			eClassList.put(OWLUtility.datarange,OWLBasePackage.eINSTANCE.getOWLDataRange());
			eClassList.put(OWLUtility.alldifferent,OWLBasePackage.eINSTANCE.getOWLAllDifferent());
			
		}
		
		return eClassList;
	}
	
	public static HashMap getEReferenceList()
	{ 
		if(eReferenceList==null)
		{
			eReferenceList = new HashMap();
			eReferenceList.put(subclassof, RDFSPackage.eINSTANCE.getRDFSClass_RDFSsubClassOf());
			eReferenceList.put(subproperyof, RDFBasePackage.eINSTANCE.getRDFProperty_RDFSsubPropertyOf());
			eReferenceList.put(domain,RDFBasePackage.eINSTANCE.getRDFProperty_RDFSdomain());
			eReferenceList.put(range,RDFBasePackage.eINSTANCE.getRDFProperty_RDFSrange());
			eReferenceList.put(comment,RDFBasePackage.eINSTANCE.getRDFSResource_RDFScomment());
			eReferenceList.put(type,RDFBasePackage.eINSTANCE.getRDFSResource_RDFtype());
			eReferenceList.put(label,RDFBasePackage.eINSTANCE.getRDFSResource_RDFSlabel());
			eReferenceList.put(member,RDFBasePackage.eINSTANCE.getRDFSResource_RDFSmember());
			eReferenceList.put(isDefinedBy,RDFBasePackage.eINSTANCE.getRDFSResource_RDFSisDefinedBy());
			eReferenceList.put(seeAlso,RDFBasePackage.eINSTANCE.getRDFSResource_RDFSseeAlso());
			eReferenceList.put(first,RDFSPackage.eINSTANCE.getRDFList_RDFfirst());
			eReferenceList.put(rest,RDFSPackage.eINSTANCE.getRDFList_RDFrest());
			eReferenceList.put(subject,RDFBasePackage.eINSTANCE.getRDFStatement_RDFsubject());
			eReferenceList.put(predicate,RDFBasePackage.eINSTANCE.getRDFStatement_RDFpredicate());
			eReferenceList.put(object,RDFBasePackage.eINSTANCE.getRDFStatement_RDFobject());
			
			
			eReferenceList.put(allValuesFromClass,OWLBasePackage.eINSTANCE.getAllValuesFromRestriction_AllValuesFromClass());
			eReferenceList.put(allValuesFromDatarange,OWLBasePackage.eINSTANCE.getAllValuesFromRestriction_AllValuesFromDataRange());
			eReferenceList.put(someValuesFromClass,OWLBasePackage.eINSTANCE.getSomeValuesFromRestriction_SomeValuesFromClass());
			eReferenceList.put(someValuesFromDatarange,OWLBasePackage.eINSTANCE.getSomeValuesFromRestriction_SomeValuesFromDataRange());
			eReferenceList.put(hasValueIndividual,OWLBasePackage.eINSTANCE.getHasValueRestriction_HasIndividualValue());
			eReferenceList.put(hasValueLiteral,OWLBasePackage.eINSTANCE.getHasValueRestriction_HasLiteralValue());
			
			eReferenceList.put(backwardCompatibleWith,OWLBasePackage.eINSTANCE.getOWLOntology_OWLbackwardCompatibleWith());
			eReferenceList.put(priorVersion,OWLBasePackage.eINSTANCE.getOWLOntology_OWLpriorVersion());
			eReferenceList.put(versionInfo,OWLBasePackage.eINSTANCE.getOWLOntology_OWLversionInfo());
			eReferenceList.put(imports,OWLBasePackage.eINSTANCE.getOWLOntology_OWLimports());
			eReferenceList.put(incompatibleWith,OWLBasePackage.eINSTANCE.getOWLOntology_OWLincompatibleWith());
			
			eReferenceList.put(intersectionOf,OWLBasePackage.eINSTANCE.getIntersectionClass_OWLintersectionOf());
			eReferenceList.put(unionOf,OWLBasePackage.eINSTANCE.getUnionClass_OWLunionOf());
			eReferenceList.put(disjointWith,OWLBasePackage.eINSTANCE.getOWLClass_OWLdisjointWith());
			eReferenceList.put(complementOf,OWLBasePackage.eINSTANCE.getComplementClass_OWLcomplementOf());
			eReferenceList.put(inverseOf,OWLBasePackage.eINSTANCE.getOWLObjectProperty_OWLinverseOf());
			eReferenceList.put(equivalentClass,OWLBasePackage.eINSTANCE.getOWLClass_OWLEquivalentClass());
			eReferenceList.put(onProperty,OWLBasePackage.eINSTANCE.getOWLRestriction_OWLonProperty());
			eReferenceList.put(equivalentProperty,OWLBasePackage.eINSTANCE.getProperty_OWLequivalentProperty());
			eReferenceList.put(sameAs,OWLBasePackage.eINSTANCE.getIndividual_OWLsameAs());
			eReferenceList.put(differentFrom,OWLBasePackage.eINSTANCE.getIndividual_OWLdifferentFrom());
			eReferenceList.put(distinctMembers,OWLBasePackage.eINSTANCE.getOWLAllDifferent_OWLdistinctMembers());
			eReferenceList.put(oneOf,OWLBasePackage.eINSTANCE.getOWLDataRange_OWLDataRangeOneOf());
			eReferenceList.put(cardinality,OWLBasePackage.eINSTANCE.getCardinalityRestriction_OWLcardinality());
			eReferenceList.put(maxCardinality,OWLBasePackage.eINSTANCE.getMaxCardinalityRestriction_OWLmaxCardinality());
			eReferenceList.put(minCardinality,OWLBasePackage.eINSTANCE.getMinCardinalityRestriction_OWLminCardinality());
			
		}
		return eReferenceList;
		
	}
	public static HashMap getFeatureIDList()
	{
		if(featureIDList==null)
		{
			featureIDList = new HashMap();
			featureIDList.put( RDFS.P_SUBCLASSOF_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SSUB_CLASS_OF));
			featureIDList.put( RDFS.P_SUBPROPERTYOF_STR, new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SSUB_PROPERTY_OF));
			featureIDList.put( RDFS.P_DOMAIN_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SDOMAIN));
			featureIDList.put( RDFS.P_RANGE_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SRANGE));
			featureIDList.put( RDFS.P_COMMENT_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SCOMMENT));
			featureIDList.put( RDF.P_TYPE_STR,		new Integer(EODMImplPackage.INTERNAL_CORE__RD_FTYPE));
			featureIDList.put( RDFS.P_LABEL_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SLABEL));
			featureIDList.put( RDFS.P_MEMBER_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SMEMBER));
			featureIDList.put( RDFS.ISDEFINEDBY_STR,new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SIS_DEFINED_BY));
			featureIDList.put( RDFS.SEEALSO_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RDF_SSEE_ALSO));
			featureIDList.put( RDF.P_FIRST_STR,		new Integer(EODMImplPackage.INTERNAL_CORE__RD_FFIRST));
			featureIDList.put( RDF.P_REST_STR,		new Integer(EODMImplPackage.INTERNAL_CORE__RD_FREST));
			featureIDList.put( RDF.P_SUBJECT_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RD_FSUBJECT));
			featureIDList.put( RDF.P_PREDICATE_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RD_FPREDICATE));
			featureIDList.put( RDF.P_OBJECT_STR,	new Integer(EODMImplPackage.INTERNAL_CORE__RD_FOBJECT));
			
			featureIDList.put(backwardCompatibleWith,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LBACKWARD_COMPATIBLE_WITH));
			featureIDList.put(priorVersion,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LPRIOR_VERSION));
			featureIDList.put(versionInfo,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LVERSION_INFO));
			featureIDList.put(imports,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LIMPORTS));
			featureIDList.put(incompatibleWith,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LINCOMPATIBLE_WITH));
			
			featureIDList.put(allValuesFromClass,new Integer(EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_CLASS));
			featureIDList.put(allValuesFromDatarange,new Integer(EODMImplPackage.INTERNAL_CORE__ALL_VALUES_FROM_DATA_RANGE));
			featureIDList.put(someValuesFromClass,new Integer(EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_CLASS));
			featureIDList.put(someValuesFromDatarange,new Integer(EODMImplPackage.INTERNAL_CORE__SOME_VALUES_FROM_DATA_RANGE));
			featureIDList.put(hasValueIndividual,new Integer(EODMImplPackage.INTERNAL_CORE__HAS_INDIVIDUAL_VALUE));
			featureIDList.put(hasValueLiteral,new Integer(EODMImplPackage.INTERNAL_CORE__HAS_LITERAL_VALUE));

			
			featureIDList.put(intersectionOf,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LINTERSECTION_OF));
			featureIDList.put(unionOf,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LUNION_OF));
			featureIDList.put(disjointWith,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LDISJOINT_WITH));
			featureIDList.put(complementOf,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LCOMPLEMENT_OF));
			featureIDList.put(inverseOf,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LINVERSE_OF));
			featureIDList.put(equivalentClass,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_CLASS));
			featureIDList.put(onProperty,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LON_PROPERTY));
			featureIDList.put(equivalentProperty,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LEQUIVALENT_PROPERTY));
			featureIDList.put(sameAs,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LSAME_AS));
			featureIDList.put(differentFrom,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LDIFFERENT_FROM));
			featureIDList.put(distinctMembers,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LDISTINCT_MEMBERS));
			//featureIDList.put(oneOf,new Integer(EODMImplPackage.INTERNAL_CORE__RD_FOBJECT));
			featureIDList.put(cardinality,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LCARDINALITY));
			featureIDList.put(maxCardinality,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LMAX_CARDINALITY));
			featureIDList.put(minCardinality,new Integer(EODMImplPackage.INTERNAL_CORE__OW_LMIN_CARDINALITY));

		}
		return featureIDList;
	}
	public static String eclass2URI(EClass classType)
	{
		String name = classType.getName();
		if(RDFBasePackage.eINSTANCE.getEClassifier(name)!=null)
		{
			switch (classType.getClassifierID()) {
			case RDFBasePackage.RDFS_RESOURCE: return OWLUtility.resource;
			case RDFBasePackage.RDF_PROPERTY: return OWLUtility.property;
			case RDFBasePackage.RDF_STATEMENT: return OWLUtility.statement;
			}
		}
		else if(RDFSPackage.eINSTANCE.getEClassifier(name)!=null)
		{
			switch (classType.getClassifierID()) {
			case RDFSPackage.RDFS_CLASS: return OWLUtility.rdfsclass;
			case RDFSPackage.RDFS_DATATYPE: return OWLUtility.datatype;
			case RDFSPackage.RDF_LIST: return OWLUtility.list;
			case RDFSPackage.RDFS_CONTAINER: return OWLUtility.container;
			case RDFSPackage.RDF_ALT: return OWLUtility.alt;
			case RDFSPackage.RDF_BAG: return OWLUtility.bag;
			case RDFSPackage.RDF_SEQ: return OWLUtility.seq;
			case RDFSPackage.RDFS_CONTAINER_MEMBERSHIP_PROPERTY: return OWLUtility.containerMembershipProperty;
			}
		}
		else if(OWLBasePackage.eINSTANCE.getEClassifier(name)!=null)
		{
			switch (classType.getClassifierID()) {
			case OWLBasePackage.OWL_ONTOLOGY: return OWLUtility.owlontology;
			//case OWLBasePackage.OWL_GRAPH: return createOWLGraph();
			case OWLBasePackage.OWL_ONTOLOGY_PROPERTY: return OWLUtility.ontologyproperty;
			case OWLBasePackage.OWL_CLASS: return OWLUtility.owlclass; 
			case OWLBasePackage.OWL_OBJECT_PROPERTY: return OWLUtility.objectproperty;
			case OWLBasePackage.OWL_DATATYPE_PROPERTY: return OWLUtility.datatypeproperty;
			
			case OWLBasePackage.OWL_ALL_DIFFERENT: return OWLUtility.alldifferent;
			case OWLBasePackage.OWL_DATA_RANGE: return OWLUtility.datarange;
			case OWLBasePackage.OWL_ANNOTATION_PROPERTY: return OWLUtility.annotationproperty;
			}
		}
		return null;
	}
	
	public static int getFeatureIDbyPredicateURI(String uri)
	{
		if(OWLUtility.getFeatureIDList().get(uri)!=null)
		{
			return ((Integer)OWLUtility.getFeatureIDList().get(uri)).intValue();
		}
		else
			return 0;
	}
	public static String nodeidGenerator()
	{
	    return "nodeid"+String.valueOf(new Date().getTime()+random.nextInt());
	}
}
