/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFBasePackage.java,v 1.2 2007/03/18 10:23:38 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.util;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBaseFactory
 * @model kind="package"
 * @generated
 */
public interface RDFBasePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rdfbase";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///odm 2006-02-17/org/omg/odm/RDF/RDFBase.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "odm 2006-02-17.org.omg.odm.RDF.RDFBase";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RDFBasePackage eINSTANCE = org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl <em>RDFS Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getRDFSResource()
	 * @generated
	 */
	int RDFS_RESOURCE = 1;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__RDF_SIS_DEFINED_BY = 0;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__RDF_SSEE_ALSO = 1;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__RD_FTYPE = 2;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__RDF_SMEMBER = 3;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__NODE_ID = 4;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__RDF_SCOMMENT = 5;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__RDF_SLABEL = 6;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__URI_REF = 7;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE__SUBJECT_STATEMENT = 8;

	/**
	 * The number of structural features of the the '<em>RDFS Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_RESOURCE_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.BlankNodeImpl <em>Blank Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.BlankNodeImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getBlankNode()
	 * @generated
	 */
	int BLANK_NODE = 0;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__RDF_SIS_DEFINED_BY = RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__RDF_SSEE_ALSO = RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__RD_FTYPE = RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__RDF_SMEMBER = RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__NODE_ID = RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__RDF_SCOMMENT = RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__RDF_SLABEL = RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__URI_REF = RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE__SUBJECT_STATEMENT = RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The number of structural features of the the '<em>Blank Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLANK_NODE_FEATURE_COUNT = RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.tmp.RDFPropertyImpl <em>RDF Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.tmp.RDFPropertyImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getRDFProperty()
	 * @generated
	 */
	int RDF_PROPERTY = 2;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SIS_DEFINED_BY = RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SSEE_ALSO = RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RD_FTYPE = RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SMEMBER = RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__NODE_ID = RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SCOMMENT = RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SLABEL = RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__URI_REF = RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__SUBJECT_STATEMENT = RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>RDF Sdomain</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SDOMAIN = RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>RDF Srange</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SRANGE = RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>RDF Ssub Property Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__RDF_SSUB_PROPERTY_OF = RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Sub Property</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY__SUB_PROPERTY = RDFS_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the the '<em>RDF Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_PROPERTY_FEATURE_COUNT = RDFS_RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSLiteralImpl <em>RDFS Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFSLiteralImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getRDFSLiteral()
	 * @generated
	 */
	int RDFS_LITERAL = 4;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__RDF_SIS_DEFINED_BY = RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__RDF_SSEE_ALSO = RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__RD_FTYPE = RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__RDF_SMEMBER = RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__NODE_ID = RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__RDF_SCOMMENT = RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__RDF_SLABEL = RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__URI_REF = RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__SUBJECT_STATEMENT = RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Lexical Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL__LEXICAL_FORM = RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>RDFS Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFS_LITERAL_FEATURE_COUNT = RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.PlainLiteralImpl <em>Plain Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.PlainLiteralImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getPlainLiteral()
	 * @generated
	 */
	int PLAIN_LITERAL = 3;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__RDF_SIS_DEFINED_BY = RDFS_LITERAL__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__RDF_SSEE_ALSO = RDFS_LITERAL__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__RD_FTYPE = RDFS_LITERAL__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__RDF_SMEMBER = RDFS_LITERAL__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__NODE_ID = RDFS_LITERAL__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__RDF_SCOMMENT = RDFS_LITERAL__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__RDF_SLABEL = RDFS_LITERAL__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__URI_REF = RDFS_LITERAL__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__SUBJECT_STATEMENT = RDFS_LITERAL__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Lexical Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__LEXICAL_FORM = RDFS_LITERAL__LEXICAL_FORM;

	/**
	 * The feature id for the '<em><b>Language</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL__LANGUAGE = RDFS_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Plain Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PLAIN_LITERAL_FEATURE_COUNT = RDFS_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl <em>URI Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getURIReference()
	 * @generated
	 */
	int URI_REFERENCE = 5;

	/**
	 * The feature id for the '<em><b>Fragment Identifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE__FRAGMENT_IDENTIFIER = 0;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE__NAMESPACE = 1;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE__RESOURCE = 2;

	/**
	 * The feature id for the '<em><b>Reified Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE__REIFIED_STATEMENT = 3;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE__URI = 4;

	/**
	 * The number of structural features of the the '<em>URI Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl <em>RDF Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFStatementImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getRDFStatement()
	 * @generated
	 */
	int RDF_STATEMENT = 6;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RDF_SIS_DEFINED_BY = RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RDF_SSEE_ALSO = RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RD_FTYPE = RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RDF_SMEMBER = RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__NODE_ID = RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RDF_SCOMMENT = RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RDF_SLABEL = RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__URI_REF = RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__SUBJECT_STATEMENT = RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Document</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__DOCUMENT = RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Reified Only</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__IS_REIFIED_ONLY = RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Reified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__IS_REIFIED = RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>RD Fsubject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RD_FSUBJECT = RDFS_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>RD Fobject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RD_FOBJECT = RDFS_RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>RD Fpredicate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__RD_FPREDICATE = RDFS_RESOURCE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Name For Reification</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT__NAME_FOR_REIFICATION = RDFS_RESOURCE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the the '<em>RDF Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_STATEMENT_FEATURE_COUNT = RDFS_RESOURCE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.UniformResourceIdentifierImpl <em>Uniform Resource Identifier</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.UniformResourceIdentifierImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getUniformResourceIdentifier()
	 * @generated
	 */
	int UNIFORM_RESOURCE_IDENTIFIER = 7;

	/**
	 * The feature id for the '<em><b>Fragment Identifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER__FRAGMENT_IDENTIFIER = URI_REFERENCE__FRAGMENT_IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Namespace</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER__NAMESPACE = URI_REFERENCE__NAMESPACE;

	/**
	 * The feature id for the '<em><b>Resource</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER__RESOURCE = URI_REFERENCE__RESOURCE;

	/**
	 * The feature id for the '<em><b>Reified Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER__REIFIED_STATEMENT = URI_REFERENCE__REIFIED_STATEMENT;

	/**
	 * The feature id for the '<em><b>Uri</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER__URI = URI_REFERENCE__URI;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER__NAME = URI_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Uniform Resource Identifier</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNIFORM_RESOURCE_IDENTIFIER_FEATURE_COUNT = URI_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl <em>RDFGraph</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getGraph()
	 * @generated
	 */
	int RDF_GRAPH = 8;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__RDF_SIS_DEFINED_BY = RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__RDF_SSEE_ALSO = RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__RD_FTYPE = RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__RDF_SMEMBER = RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__NODE_ID = RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__RDF_SCOMMENT = RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__RDF_SLABEL = RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__URI_REF = RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__SUBJECT_STATEMENT = RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Graphstatement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__GRAPHSTATEMENT = RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>RDFGraph Name</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH__GRAPH_NAME = RDFS_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>RDFGraph</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDF_GRAPH_FEATURE_COUNT = RDFS_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceNodeImpl <em>URI Reference Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.URIReferenceNodeImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getURIReferenceNode()
	 * @generated
	 */
	int URI_REFERENCE_NODE = 9;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__RDF_SIS_DEFINED_BY = RDFS_RESOURCE__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__RDF_SSEE_ALSO = RDFS_RESOURCE__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__RD_FTYPE = RDFS_RESOURCE__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__RDF_SMEMBER = RDFS_RESOURCE__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__NODE_ID = RDFS_RESOURCE__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__RDF_SCOMMENT = RDFS_RESOURCE__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__RDF_SLABEL = RDFS_RESOURCE__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__URI_REF = RDFS_RESOURCE__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE__SUBJECT_STATEMENT = RDFS_RESOURCE__SUBJECT_STATEMENT;

	/**
	 * The number of structural features of the the '<em>URI Reference Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int URI_REFERENCE_NODE_FEATURE_COUNT = RDFS_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.TypedLiteralImpl <em>Typed Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.TypedLiteralImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getTypedLiteral()
	 * @generated
	 */
	int TYPED_LITERAL = 10;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__RDF_SIS_DEFINED_BY = RDFS_LITERAL__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__RDF_SSEE_ALSO = RDFS_LITERAL__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__RD_FTYPE = RDFS_LITERAL__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__RDF_SMEMBER = RDFS_LITERAL__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__NODE_ID = RDFS_LITERAL__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__RDF_SCOMMENT = RDFS_LITERAL__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__RDF_SLABEL = RDFS_LITERAL__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__URI_REF = RDFS_LITERAL__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__SUBJECT_STATEMENT = RDFS_LITERAL__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Lexical Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__LEXICAL_FORM = RDFS_LITERAL__LEXICAL_FORM;

	/**
	 * The feature id for the '<em><b>Datatype URI</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL__DATATYPE_URI = RDFS_LITERAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Typed Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPED_LITERAL_FEATURE_COUNT = RDFS_LITERAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFXMLLiteralImpl <em>RDFXML Literal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFXMLLiteralImpl
	 * @see org.eclipse.eodm.rdf.rdfbase.impl.RDFBasePackageImpl#getRDFXMLLiteral()
	 * @generated
	 */
	int RDFXML_LITERAL = 11;

	/**
	 * The feature id for the '<em><b>RDF Sis Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__RDF_SIS_DEFINED_BY = TYPED_LITERAL__RDF_SIS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>RDF Ssee Also</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__RDF_SSEE_ALSO = TYPED_LITERAL__RDF_SSEE_ALSO;

	/**
	 * The feature id for the '<em><b>RD Ftype</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__RD_FTYPE = TYPED_LITERAL__RD_FTYPE;

	/**
	 * The feature id for the '<em><b>RDF Smember</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__RDF_SMEMBER = TYPED_LITERAL__RDF_SMEMBER;

	/**
	 * The feature id for the '<em><b>Node ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__NODE_ID = TYPED_LITERAL__NODE_ID;

	/**
	 * The feature id for the '<em><b>RDF Scomment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__RDF_SCOMMENT = TYPED_LITERAL__RDF_SCOMMENT;

	/**
	 * The feature id for the '<em><b>RDF Slabel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__RDF_SLABEL = TYPED_LITERAL__RDF_SLABEL;

	/**
	 * The feature id for the '<em><b>Uri Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__URI_REF = TYPED_LITERAL__URI_REF;

	/**
	 * The feature id for the '<em><b>Subject Statement</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__SUBJECT_STATEMENT = TYPED_LITERAL__SUBJECT_STATEMENT;

	/**
	 * The feature id for the '<em><b>Lexical Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__LEXICAL_FORM = TYPED_LITERAL__LEXICAL_FORM;

	/**
	 * The feature id for the '<em><b>Datatype URI</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL__DATATYPE_URI = TYPED_LITERAL__DATATYPE_URI;

	/**
	 * The number of structural features of the the '<em>RDFXML Literal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RDFXML_LITERAL_FEATURE_COUNT = TYPED_LITERAL_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.BlankNode <em>Blank Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Blank Node</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.BlankNode
	 * @generated
	 */
	EClass getBlankNode();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource <em>RDFS Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFS Resource</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource
	 * @generated
	 */
	EClass getRDFSResource();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSisDefinedBy <em>RDF Sis Defined By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Sis Defined By</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSisDefinedBy()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_RDFSisDefinedBy();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSseeAlso <em>RDF Ssee Also</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Ssee Also</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSseeAlso()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_RDFSseeAlso();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFtype <em>RD Ftype</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RD Ftype</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFtype()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_RDFtype();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSmember <em>RDF Smember</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Smember</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSmember()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_RDFSmember();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getNodeID <em>Node ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Node ID</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getNodeID()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EAttribute getRDFSResource_NodeID();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFScomment <em>RDF Scomment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>RDF Scomment</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFScomment()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_RDFScomment();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSlabel <em>RDF Slabel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>RDF Slabel</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getRDFSlabel()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_RDFSlabel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getUriRef <em>Uri Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Uri Ref</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getUriRef()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_UriRef();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getSubjectStatement <em>Subject Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Subject Statement</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getSubjectStatement()
	 * @see #getRDFSResource()
	 * @generated
	 */
	EReference getRDFSResource_SubjectStatement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty <em>RDF Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDF Property</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty
	 * @generated
	 */
	EClass getRDFProperty();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSdomain <em>RDF Sdomain</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Sdomain</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSdomain()
	 * @see #getRDFProperty()
	 * @generated
	 */
	EReference getRDFProperty_RDFSdomain();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSrange <em>RDF Srange</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Srange</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSrange()
	 * @see #getRDFProperty()
	 * @generated
	 */
	EReference getRDFProperty_RDFSrange();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSsubPropertyOf <em>RDF Ssub Property Of</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>RDF Ssub Property Of</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSsubPropertyOf()
	 * @see #getRDFProperty()
	 * @generated
	 */
	EReference getRDFProperty_RDFSsubPropertyOf();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getSubProperty <em>Sub Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Sub Property</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getSubProperty()
	 * @see #getRDFProperty()
	 * @generated
	 */
	EReference getRDFProperty_SubProperty();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.PlainLiteral <em>Plain Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Plain Literal</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.PlainLiteral
	 * @generated
	 */
	EClass getPlainLiteral();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfbase.PlainLiteral#getLanguage <em>Language</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Language</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.PlainLiteral#getLanguage()
	 * @see #getPlainLiteral()
	 * @generated
	 */
	EAttribute getPlainLiteral_Language();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral <em>RDFS Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFS Literal</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSLiteral
	 * @generated
	 */
	EClass getRDFSLiteral();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral#getLexicalForm <em>Lexical Form</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lexical Form</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSLiteral#getLexicalForm()
	 * @see #getRDFSLiteral()
	 * @generated
	 */
	EAttribute getRDFSLiteral_LexicalForm();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.URIReference <em>URI Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>URI Reference</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference
	 * @generated
	 */
	EClass getURIReference();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getFragmentIdentifier <em>Fragment Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Fragment Identifier</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getFragmentIdentifier()
	 * @see #getURIReference()
	 * @generated
	 */
	EReference getURIReference_FragmentIdentifier();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getNamespace <em>Namespace</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Namespace</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getNamespace()
	 * @see #getURIReference()
	 * @generated
	 */
	EReference getURIReference_Namespace();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getResource <em>Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Resource</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getResource()
	 * @see #getURIReference()
	 * @generated
	 */
	EReference getURIReference_Resource();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getReifiedStatement <em>Reified Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Reified Statement</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getReifiedStatement()
	 * @see #getURIReference()
	 * @generated
	 */
	EReference getURIReference_ReifiedStatement();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getUri <em>Uri</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Uri</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getUri()
	 * @see #getURIReference()
	 * @generated
	 */
	EReference getURIReference_Uri();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement <em>RDF Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDF Statement</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement
	 * @generated
	 */
	EClass getRDFStatement();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getDocument <em>Document</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Document</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getDocument()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EReference getRDFStatement_Document();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReifiedOnly <em>Is Reified Only</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Reified Only</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReifiedOnly()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EAttribute getRDFStatement_IsReifiedOnly();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReified <em>Is Reified</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Reified</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReified()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EAttribute getRDFStatement_IsReified();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFsubject <em>RD Fsubject</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>RD Fsubject</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFsubject()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EReference getRDFStatement_RDFsubject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFobject <em>RD Fobject</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>RD Fobject</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFobject()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EReference getRDFStatement_RDFobject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFpredicate <em>RD Fpredicate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>RD Fpredicate</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFpredicate()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EReference getRDFStatement_RDFpredicate();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getNameForReification <em>Name For Reification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Name For Reification</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement#getNameForReification()
	 * @see #getRDFStatement()
	 * @generated
	 */
	EReference getRDFStatement_NameForReification();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier <em>Uniform Resource Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Uniform Resource Identifier</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier
	 * @generated
	 */
	EClass getUniformResourceIdentifier();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier#getName()
	 * @see #getUniformResourceIdentifier()
	 * @generated
	 */
	EAttribute getUniformResourceIdentifier_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph <em>RDFGraph</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFGraph</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph
	 * @generated
	 */
	EClass getGraph();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphstatement <em>Graphstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Graphstatement</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphstatement()
	 * @see #getGraph()
	 * @generated
	 */
	EReference getGraph_Graphstatement();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphName <em>RDFGraph Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>RDFGraph Name</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph#getGraphName()
	 * @see #getGraph()
	 * @generated
	 */
	EReference getGraph_GraphName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.URIReferenceNode <em>URI Reference Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>URI Reference Node</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReferenceNode
	 * @generated
	 */
	EClass getURIReferenceNode();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.TypedLiteral <em>Typed Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Typed Literal</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.TypedLiteral
	 * @generated
	 */
	EClass getTypedLiteral();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.eodm.rdf.rdfbase.TypedLiteral#getDatatypeURI <em>Datatype URI</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Datatype URI</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.TypedLiteral#getDatatypeURI()
	 * @see #getTypedLiteral()
	 * @generated
	 */
	EReference getTypedLiteral_DatatypeURI();

	/**
	 * Returns the meta object for class '{@link org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral <em>RDFXML Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>RDFXML Literal</em>'.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral
	 * @generated
	 */
	EClass getRDFXMLLiteral();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RDFBaseFactory getrdfbaseFactory();

} //RDFBasePackage
