/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLClass.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.rdf.rdfs.RDFSClass;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>OWL Class</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLClass#isIsDeprecated <em>isDeprecated</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLClass#getIsClassKind <em>isClassKind</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLClass#getHasRestrictionKind <em>hasRestrictionKind</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLClass#getEquivalentClass <em>owLequivalentClass</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.OWLClass#getOWLdisjointWith <em>OWLdisjointWith</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLClass()
 * @model
 * @generated
 */
public interface OWLClass extends RDFSClass, Universe {
	/**
	 * Returns the value of the '<em><b>isDeprecated</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Deprecated</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isDeprecated</em>' attribute.
	 * @see #setIsDeprecated(boolean)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLClass_IsDeprecated()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsDeprecated();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLClass#isIsDeprecated <em>isDeprecated</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isDeprecated</em>' attribute.
	 * @see #isIsDeprecated()
	 * @generated
	 */
	void setIsDeprecated(boolean value);

	/**
	 * Returns the value of the '<em><b>isClassKind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Class Kind</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isClassKind</em>' containment reference.
	 * @see #setIsClassKind(EObject)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLClass_IsClassKind()
	 * @model containment="true" required="true" derived="true"
	 * @generated
	 */
	EObject getIsClassKind();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLClass#getIsClassKind <em>isClassKind</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isClassKind</em>' containment reference.
	 * @see #getIsClassKind()
	 * @generated
	 */
	void setIsClassKind(EObject value);

	/**
	 * Returns the value of the '<em><b>hasRestrictionKind</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Has Restriction Kind</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>hasRestrictionKind</em>' containment reference.
	 * @see #setHasRestrictionKind(EObject)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLClass_HasRestrictionKind()
	 * @model containment="true" required="true" derived="true"
	 * @generated
	 */
	EObject getHasRestrictionKind();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.OWLClass#getHasRestrictionKind <em>hasRestrictionKind</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>hasRestrictionKind</em>' containment reference.
	 * @see #getHasRestrictionKind()
	 * @generated
	 */
	void setHasRestrictionKind(EObject value);

	/**
	 * Returns the value of the '<em><b>OWLequivalentClass</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Equivalent Class</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>eOWLquivalentClass</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLClass_OWLEquivalentClass()
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLClass"
	 * @generated
	 */
	EList getOWLEquivalentClass();

	/**
	 * Returns the value of the '<em><b>OWLdisjointWith</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Ldisjoint With</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLdisjointWith</em>' reference list.
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getOWLClass_OWLdisjointWith()
	 * @model type="org.eclipse.eodm.owl.owlbase.OWLClass"
	 * @generated
	 */
	EList getOWLdisjointWith();
	
	/**
	 * Returns the value of the '<em><b>Complement Class</em></b>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.ComplementClass}.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.ComplementClass#getOWLcomplementOf()}.
	 * 
	 * @return the value of the '<em><b>Complement Class</em></b>' reference list.
	 * @eodmext This method is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	EList getComplementClass();
	
	/**
	 * Returns the value of the '<em><b>Intersection Class</em></b>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.IntersectionClass}.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.IntersectionClass#getOWLintersectionOf()}.
	 * 
	 * @return the value of the '<em><b>Intersection Class</em></b>' reference list.
	 * @eodmext This method is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	EList getIntersectionClass();
	
	/**
	 * Returns the value of the '<em><b>Union Class</em></b>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.UnionClass}.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.UnionClass#getOWLunionOf()}.
	 * 
	 * @return the value of the '<em><b>Union Class</em></b>' reference list.
	 * @eodmext This method is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	EList getUnionClass();
		
	/**
	 * Returns the value of the '<em><b>Disjoint Class</em></b>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLClass}.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.OWLClass#getOWLdisjointWith()}.
	 * 
	 * @return the value of the '<em><b>Disjoint Class</em></b>' reference list.
	 * @eodmext This method is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */
	EList getDisjointClass();
	
	/**
	 * Returns the value of the '<em><b>Equivalent Class</em></b>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.owl.owlbase.OWLClass}.
	 * It is the reverse of {@link org.eclipse.eodm.owl.owlbase.OWLClass#getOWLEquivalentClass()}.
	 * 
	 * @return the value of the '<em><b>Equivalent Class</em></b>' reference list.
	 * @eodmext This method is not part of ODM 2006-04-03 specification. It is added by EODM for convenient access.
	 */	
	EList getEquivalentClass();
	

} // OWLClass
