/*****************************************************************************
 * Copyright (c) 2015 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *****************************************************************************/

package org.eclipse.papyrus.interoperability.rpy.handlers;

import org.eclipse.papyrus.interoperability.rpy.importer.utils.RpyFileUtils;
import org.eclipse.papyrus.interoperability.rpy.transformations.RpyImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.handler.AbstractMigrationHandler;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformationLauncher;
import org.eclipse.swt.widgets.Control;

import com.google.common.collect.Sets;

/**
 * 
 * The handler to run Rpy import action when a file is selected
 *
 */
public class ImportRpyHandler extends AbstractMigrationHandler {

	/**
	 * 
	 * Constructor.
	 *
	 */
	public ImportRpyHandler() {
		super(Sets.newHashSet(RpyFileUtils.FILE_EXTENSION_RPY, RpyFileUtils.UML_RPY_FILE));
	}

	/**
	 * 
	 * @see org.eclipse.papyrus.uml.m2m.qvto.common.handler.AbstractMigrationHandler#createImportTransformationLauncher(org.eclipse.papyrus.migration.common.MigrationParameters.Config, org.eclipse.swt.widgets.Control)
	 *
	 * @param config
	 * @param baseControl
	 * @return
	 */
	@Override
	protected IImportTransformationLauncher createImportTransformationLauncher(ThreadConfig config, Control baseControl) {
		return new RpyImportTransformationLauncher(config, baseControl);
	}

}
