/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.PluginClassLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class ASMProjector {
    public static void realMain(String[] args, PluginClassLoader pcl) throws Exception {
        String modelLoaderName;
        System.out.println("ATL 0.2 Projector");
        System.out.println();
        long start = new Date().getTime();
        Map params = ASMProjector.parseCommandLine(args);
        String plugins = (String)params.get("plugins");
        if (plugins != null) {
            String[] ss = plugins.split(",");
            for (String plg : Arrays.asList(ss)) {
                ATLLogger.info((String)("Loading plugin: " + plg));
                pcl.addLocation(plg);
            }
        }
        if ((modelLoaderName = (String)params.get("ModelLoader")) == null) {
            modelLoaderName = "MDR";
        }
        ModelLoader ml = null;
        ml = modelLoaderName.equals("MDR") ? (ModelLoader)pcl.loadClass("org.eclipse.m2m.atl.drivers.mdr4atl.MDRModelLoader").newInstance() : (ModelLoader)pcl.loadClass("org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader").newInstance();
        try {
            ml.addInjector("ebnf", pcl.loadClass("org.eclipse.gmt.tcs.injector.TCSInjector"));
            ml.addInjector("ebnf2", pcl.loadClass("org.eclipse.gmt.tcs.injector.TCSInjector"));
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            ml.addExtractor("ebnf", pcl.loadClass("org.eclipse.gmt.tcs.extractor.TCSExtractor"));
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            ml.addInjector("bin", pcl.loadClass("org.atl.engine.injectors.bin.BINInjector"));
        }
        catch (Exception e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        ASMModel MOF = ml.getMOF();
        models.put("MOF", MOF);
        ASMProjector.loadModels("preload", params, models, ml);
        ASMModel M = ASMProjector.loadModels("source", params, models, ml);
        String target = (String)params.get("target");
        ml.save(M, target);
        long end = new Date().getTime();
        System.out.println("Execution took " + (double)(end - start) / 1000.0 + "s.");
    }

    private static ASMModel loadModels(String name, Map params, Map models, ModelLoader ml) throws IOException {
        ASMModel ret = null;
        String list = (String)params.get(name);
        if (list != null) {
            String[] elems = list.split(",");
            int i = 0;
            while (i < elems.length) {
                ASMModel M;
                String[] names = elems[i].split(":");
                String MName = names[0];
                String MMName = names[1];
                ASMModel MM = MMName.equals("MOF") ? (ASMModel)models.get("MOF") : ml.loadModel(MMName, (ASMModel)models.get("MOF"), (String)params.get(MMName));
                ret = M = ml.loadModel(MName, MM, (String)params.get(MName));
                ++i;
            }
        }
        return ret;
    }

    private static Map parseCommandLine(String[] args) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].matches("^[^=]*=.*$")) {
                String[] p = args[i].split("=");
                String s = "";
                int j = 1;
                while (j < p.length) {
                    s = String.valueOf(s) + (j != 1 ? "=" : "") + p[j];
                    ++j;
                }
                if (parameters.containsKey(p[0])) {
                    parameters.put(p[0], parameters.get(p[0]) + "," + s);
                } else {
                    parameters.put(p[0], s);
                }
            }
            ++i;
        }
        return parameters;
    }
}

