/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GradientSelectionDialog
extends Dialog {
    protected Button color1Button;
    protected Button color2Button;
    protected Canvas canvas;
    private Button verticalStyle;
    private Button horizontalStyle;
    private Button okButton;
    private Button cancelButton;
    private Button clearButton;
    private RGB gradientColor1;
    private RGB gradientColor2;
    private int gradientStyle;
    private int transparency;
    int returnVal;
    ArrayList<Resource> resources;

    public GradientSelectionDialog(Shell parent, int style, RGB initColor1, RGB initColor2, int defaultGradientStyle, int transparency) {
        super(parent, style);
        this.setGradientColor1(initColor1);
        this.setGradientColor2(initColor2);
        this.setGradientStyle(defaultGradientStyle);
        if (transparency < 0 || transparency > 100) {
            this.setTransparency(0);
        } else {
            this.setTransparency(transparency);
        }
        this.returnVal = 256;
        this.resources = new ArrayList();
    }

    public int open() {
        return this.open(null);
    }

    public int open(Point location) {
        final Shell dialog = new Shell(this.getParent(), 0x860 | this.getStyle());
        dialog.setText(CommonUIMessages.GradientSelection_Gradient);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        dialog.setLayout((Layout)gridLayout);
        this.createDialogControls(dialog);
        dialog.setDefaultButton(this.okButton);
        dialog.pack();
        Rectangle bounds = dialog.getBounds();
        if (location == null) {
            Rectangle rect = this.getParent().getMonitor().getBounds();
            dialog.setLocation(rect.x + (rect.width - bounds.width) / 2, rect.y + (rect.height - bounds.height) / 2);
        } else {
            dialog.setLocation(location);
        }
        dialog.setMinimumSize(bounds.width, bounds.height);
        dialog.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < GradientSelectionDialog.this.resources.size()) {
                    Resource obj = GradientSelectionDialog.this.resources.get(i);
                    if (obj != null && obj instanceof Resource) {
                        obj.dispose();
                    }
                    ++i;
                }
                dialog.dispose();
            }
        });
        dialog.open();
        Display display = this.getParent().getDisplay();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnVal;
    }

    protected void createDialogControls(Shell parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite topComposite = new Composite((Composite)parent, 0);
        topComposite.setLayout((Layout)layout);
        this.createColorGroup(parent, topComposite);
        this.createStyleGroup(topComposite);
        this.createSample(parent, topComposite);
        this.createOkCancelClearButtons(parent, topComposite);
    }

    protected void createColorGroup(Shell parent, Composite topComposite) {
        final Display display = parent.getDisplay();
        Group colorGroup = new Group(topComposite, 0);
        colorGroup.setText(CommonUIMessages.GradientSelection_Colors);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        colorGroup.setLayout((Layout)layout);
        colorGroup.setLayoutData((Object)gridData);
        Label label = new Label((Composite)colorGroup, 0);
        label.setText(CommonUIMessages.GradientSelection_Color1);
        label = new Label((Composite)colorGroup, 0);
        label.setText(CommonUIMessages.GradientSelection_Color2);
        this.color1Button = new Button((Composite)colorGroup, 8);
        this.setButtonImage(this.color1Button, this.gradientColor1, display);
        this.color1Button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RGB color = GradientSelectionDialog.this.changeColor(GradientSelectionDialog.this.color1Button, display, GradientSelectionDialog.this.gradientColor1);
                if (color != null) {
                    GradientSelectionDialog.this.setGradientColor1(color);
                }
            }
        });
        this.color2Button = new Button((Composite)colorGroup, 8);
        this.setButtonImage(this.color2Button, this.gradientColor2, display);
        this.color2Button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RGB color = GradientSelectionDialog.this.changeColor(GradientSelectionDialog.this.color2Button, display, GradientSelectionDialog.this.gradientColor2);
                if (color != null) {
                    GradientSelectionDialog.this.setGradientColor2(color);
                }
            }
        });
    }

    protected void createStyleGroup(Composite topComposite) {
        Group styleGroup = new Group(topComposite, 0);
        styleGroup.setText(CommonUIMessages.GradientSelection_ShadingStyle);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        styleGroup.setLayout((Layout)layout);
        styleGroup.setLayoutData((Object)gridData);
        this.verticalStyle = new Button((Composite)styleGroup, 16);
        this.verticalStyle.setText(CommonUIMessages.GradientSelection_Vertical);
        this.verticalStyle.setSelection(this.gradientStyle == 0);
        this.horizontalStyle = new Button((Composite)styleGroup, 16);
        this.horizontalStyle.setText(CommonUIMessages.GradientSelection_Horizontal);
        this.horizontalStyle.setSelection(this.gradientStyle == 1);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                GradientSelectionDialog.this.changeStyle();
            }
        };
        this.verticalStyle.addSelectionListener((SelectionListener)selectionListener);
        this.horizontalStyle.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void createSample(Shell parent, Composite topComposite) {
        final Display display = parent.getDisplay();
        Composite sampleComposite = new Composite(topComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 1024;
        sampleComposite.setLayout((Layout)layout);
        sampleComposite.setLayoutData((Object)gridData);
        Label message = new Label(sampleComposite, 0);
        message.setText(CommonUIMessages.GradientSelection_Sample);
        gridData = new GridData(256);
        message.setLayoutData((Object)gridData);
        this.canvas = new Canvas(sampleComposite, 0);
        gridData = new GridData(1808);
        gridData.widthHint = 35;
        gridData.heightHint = 35;
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point size = GradientSelectionDialog.this.canvas.getSize();
                Color color1 = new Color((Device)display, GradientSelectionDialog.this.gradientColor1);
                Color color2 = new Color((Device)display, GradientSelectionDialog.this.gradientColor2);
                Image sample = new Image((Device)display, size.x, size.y);
                GC gc = new GC((Drawable)sample);
                Rectangle rect = sample.getBounds();
                gc.setForeground(color1);
                gc.setBackground(color2);
                gc.setAlpha(255 - GradientSelectionDialog.this.transparency * 255 / 100);
                gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, GradientSelectionDialog.this.gradientStyle == 0);
                gc.setForeground(display.getSystemColor(2));
                gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
                e.gc.drawImage(sample, 0, 0);
                gc.dispose();
                sample.dispose();
                color1.dispose();
                color2.dispose();
            }
        });
    }

    protected void createOkCancelClearButtons(Shell parent, Composite topComposite) {
        Composite okCancelComp = new Composite(topComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        okCancelComp.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1024;
        gridData.horizontalSpan = 3;
        okCancelComp.setLayout((Layout)layout);
        okCancelComp.setLayoutData((Object)gridData);
        this.createOkButton(okCancelComp, parent);
        this.createCancelButton(okCancelComp, parent);
        this.createClearButton(okCancelComp, parent);
    }

    protected void createCancelButton(Composite okCancelComp, final Shell parent) {
        this.cancelButton = new Button(okCancelComp, 8);
        this.cancelButton.setText(CommonUIMessages.ShowHideRelationshipsDialog_Button_Cancel);
        this.cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                parent.close();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cancelButton.setLayoutData((Object)gridData);
    }

    protected void createOkButton(Composite okCancelComp, final Shell parent) {
        this.okButton = new Button(okCancelComp, 8);
        this.okButton.setText(CommonUIMessages.ShowHideRelationshipsDialog_Button_OK);
        this.okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientSelectionDialog.this.returnVal = 32;
                parent.close();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.okButton.setLayoutData((Object)gridData);
    }

    protected void createClearButton(Composite okCancelComp, final Shell parent) {
        this.clearButton = new Button(okCancelComp, 8);
        this.clearButton.setText(CommonUIMessages.ClearAction_label);
        this.clearButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientSelectionDialog.this.returnVal = -1;
                parent.close();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.clearButton.setLayoutData((Object)gridData);
    }

    protected RGB changeColor(Button button, Display display, RGB currentColor) {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        dialog.setRGB(currentColor);
        WindowUtil.centerDialog(dialog.getParent(), Display.getCurrent().getActiveShell());
        dialog.open();
        RGB selectedColor = dialog.getRGB();
        if (selectedColor != null) {
            this.setButtonImage(button, selectedColor, display);
            this.canvas.redraw();
        }
        return selectedColor;
    }

    protected void setButtonImage(Button btn, RGB rgbColor, Display display) {
        Image image = btn.getImage();
        if (image != null) {
            this.resources.remove(image);
            image.dispose();
        }
        Color color1 = new Color((Device)display, rgbColor);
        image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color1);
        Rectangle rect = image.getBounds();
        gc.fillRectangle(rect);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.dispose();
        color1.dispose();
        btn.setImage(image);
        this.resources.add((Resource)image);
    }

    protected Canvas getSampleCanvas() {
        return this.canvas;
    }

    private void changeStyle() {
        this.gradientStyle = this.verticalStyle.getSelection() ? 0 : 1;
        this.canvas.redraw();
    }

    public RGB getGradientColor1() {
        return this.gradientColor1;
    }

    public void setGradientColor1(RGB gradientColor1) {
        this.gradientColor1 = gradientColor1;
    }

    public RGB getGradientColor2() {
        return this.gradientColor2;
    }

    public void setGradientColor2(RGB gradientColor2) {
        this.gradientColor2 = gradientColor2;
    }

    public int getGradientStyle() {
        return this.gradientStyle;
    }

    public void setGradientStyle(int gradientStyle) {
        this.gradientStyle = gradientStyle;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }
}

