/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.tests.xpand.TestsResourceManager;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;

public class AopFeatureTest
extends TestCase {
    private ExecutionContextImpl execCtx;
    private StringBuilder buffer;
    private EClassifier oclAnyType;
    private EClassifier oclStringType;

    protected void setUp() throws Exception {
        super.setUp();
        if (QvtPlugin.getDefault() == null) {
            new QvtPlugin();
        }
        this.buffer = new StringBuilder();
        this.execCtx = new ExecutionContextImpl(new Scope((ResourceManager)new TestsResourceManager(), null, (Output)new BufferOutput(this.buffer)));
        this.execCtx.getScope().registerAdvices(String.valueOf(AopFeatureTest.prefix()) + "Advices1");
        this.oclAnyType = (EClassifier)this.execCtx.getOCLEnvironment().getOCLStandardLibrary().getOclAny();
        this.oclStringType = (EClassifier)this.execCtx.getOCLEnvironment().getOCLStandardLibrary().getString();
    }

    public final void test_test1_Object() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::advtest1", this.oclAnyType, null);
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"12", (String)this.buffer.toString());
    }

    public final void test_test2_Object() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::advtest2", this.oclAnyType, null);
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"13", (String)this.buffer.toString());
    }

    public final void test_te2st_Object() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::te2st", this.oclAnyType, null);
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"4", (String)this.buffer.toString());
    }

    public final void test_test1_String() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::advtest1", this.oclStringType, null);
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"1258", (String)this.buffer.toString());
    }

    public final void test_test1_StringParam_String() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::advtest1", this.oclStringType, new EClassifier[]{this.oclStringType});
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"678", (String)this.buffer.toString());
    }

    public final void test_test1_StringParams_String() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::advtest1", this.oclStringType, new EClassifier[]{this.oclStringType, this.oclStringType});
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"78", (String)this.buffer.toString());
    }

    public final void testQualifiedAspect() throws AmbiguousDefinitionException {
        XpandDefinition def = this.execCtx.findDefinition(String.valueOf(AopFeatureTest.prefix()) + "Adviced::advtest3", this.oclStringType, null);
        def.evaluate((ExecutionContext)this.execCtx);
        AopFeatureTest.assertEquals((String)"15qualified-test3", (String)this.buffer.toString());
    }

    private static String prefix() {
        return "org::eclipse::gmf::tests::xpand::evaluate::";
    }
}

