/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.impl;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.net4j.examples.prov.server.FileHttpd;
import org.eclipse.net4j.examples.prov.server.impl.AbstractHttpd;
import org.eclipse.net4j.spring.ValidationException;

public class FileHttpdImpl
extends AbstractHttpd
implements FileHttpd {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private String documentRoot;
    private boolean allowDirectoryListing;
    private boolean autoSync;
    private List welcomePages;
    private transient IFolder rootFolder;

    protected AbstractHttpd.Response serve(String uri, String method, Properties headers, Properties parms) {
        if (this.isDebugEnabled()) {
            this.dump(uri, method, headers, parms);
        }
        if ((uri = uri.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        if (uri.indexOf("..") != -1) {
            return new AbstractHttpd.Response("403 Forbidden", "text/plain", "FORBIDDEN: Won't serve .. for security reasons.");
        }
        AbstractHttpd.Response overridden = this.overrideUri(uri, method, headers, parms);
        if (overridden != null) {
            return overridden;
        }
        IFolder folder = this.rootFolder.getFolder(uri);
        boolean folderExists = folder.exists();
        if (!folderExists && this.autoSync) {
            folderExists = this.sync((IResource)folder);
        }
        if (folderExists) {
            if (!uri.endsWith("/")) {
                uri = String.valueOf(uri) + "/";
                String data = "<html><body>Redirected: <a href=\"" + uri + "\">" + uri + "</a></body></html>";
                AbstractHttpd.Response r = new AbstractHttpd.Response("307 Temporary Redirect", "text/html", data);
                r.addHeader("Location", uri);
                return r;
            }
            for (String welcomePage : this.welcomePages) {
                IFile file = folder.getFile(welcomePage);
                if (!file.exists()) continue;
                return this.serveFile(file, String.valueOf(uri) + "/" + welcomePage, headers);
            }
            if (!this.allowDirectoryListing) {
                return new AbstractHttpd.Response("403 Forbidden", "text/plain", "FORBIDDEN: No directory listing.");
            }
            return this.serveFolder(folder, uri, headers);
        }
        IFile file = this.rootFolder.getFile(uri);
        boolean fileExists = file.exists();
        if (!fileExists && this.autoSync) {
            fileExists = this.sync((IResource)file);
        }
        if (fileExists) {
            return this.serveFile(file, uri, headers);
        }
        return new AbstractHttpd.Response("404 Not Found", "text/plain", "Error 404, file not found.");
    }

    private boolean sync(IResource resource) {
        File fs = new File(resource.getLocation().toString());
        if (!fs.exists()) {
            return false;
        }
        try {
            resource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            this.warn("Can't refresh resource " + resource, ex);
            return false;
        }
        return resource.exists();
    }

    protected AbstractHttpd.Response serveFolder(IFolder folder, String path, Properties headers) {
        String u;
        int slash;
        String msg = "<html><body><h1>Directory " + path + "</h1><br/>";
        if (path.length() > 1 && (slash = (u = path.substring(0, path.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
            msg = String.valueOf(msg) + "<b><a href=\"" + path.substring(0, slash + 1) + "\">..</a></b><br/>";
        }
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                boolean dir = resources[i] instanceof IFolder;
                String member = resources[i].getName();
                if (dir) {
                    msg = String.valueOf(msg) + "<b>";
                    member = String.valueOf(member) + "/";
                }
                msg = String.valueOf(msg) + "<a href=\"" + this.encodeUri(String.valueOf(path) + member) + "\">" + member + "</a>";
                if (!dir) {
                    long len = this.getFileLength((IFile)resources[i]);
                    msg = String.valueOf(msg) + " &nbsp;<font size=2>(";
                    msg = len == 1L ? String.valueOf(msg) + "1 byte" : (len < 1024L ? String.valueOf(msg) + len + " bytes" : (len < 0x100000L ? String.valueOf(msg) + len / 1024L + "." + len % 1024L / 10L % 100L + " KB" : (len < 0x40000000L ? String.valueOf(msg) + len / 0x100000L + "." + len % 0x100000L / 10L % 100L + " MB" : String.valueOf(msg) + len / 0x40000000L + "." + len % 0x40000000L / 10L % 100L + " GB")));
                    msg = String.valueOf(msg) + ")</font>";
                }
                msg = String.valueOf(msg) + "<br/>";
                if (dir) {
                    msg = String.valueOf(msg) + "</b>";
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.error("Error while listing directory", ex);
        }
        return new AbstractHttpd.Response("200 OK", "text/html", msg);
    }

    protected long getFileLength(IFile file) {
        return new File(file.getLocation().toString()).length();
    }

    protected AbstractHttpd.Response serveFile(IFile file, String path, Properties headers) {
        String mime = this.getMimeType(file);
        long len = this.getFileLength(file);
        try {
            long startFrom = 0L;
            String range = headers.getProperty("Range");
            if (range != null && range.startsWith("bytes=")) {
                int minus = (range = range.substring("bytes=".length())).indexOf(45);
                if (minus > 0) {
                    range = range.substring(0, minus);
                }
                try {
                    startFrom = Long.parseLong(range);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            InputStream fis = file.getContents();
            fis.skip(startFrom);
            AbstractHttpd.Response r = new AbstractHttpd.Response("200 OK", mime, fis);
            r.addHeader("Content-length", Long.toString(len - startFrom));
            r.addHeader("Content-range", String.valueOf(Long.toString(startFrom)) + "-" + (len - 1L) + "/" + len);
            return r;
        }
        catch (Exception ex) {
            return new AbstractHttpd.Response("500 Internal Server Error", "text/plain", ex.toString());
        }
    }

    protected String getMimeType(IFile file) {
        String ext = file.getFileExtension();
        String mime = null;
        if (ext != null && ext.length() != 0) {
            mime = this.getMimeType(ext.toLowerCase());
        }
        if (mime == null) {
            mime = "application/octet-stream";
        }
        return mime;
    }

    protected AbstractHttpd.Response overrideUri(String path, String method, Properties headers, Properties parms) {
        return null;
    }

    public IFolder getRootFolder() {
        return this.rootFolder;
    }

    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public void setDocumentRoot(String documentRoot) {
        this.doSet("documentRoot", documentRoot);
    }

    public boolean isAllowDirectoryListing() {
        return this.allowDirectoryListing;
    }

    public void setAllowDirectoryListing(boolean allowDirectoryListing) {
        this.doSet("allowDirectoryListing", allowDirectoryListing);
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public void setAutoSync(boolean autoSync) {
        this.doSet("autoSync", autoSync);
    }

    public List getWelcomePages() {
        return this.welcomePages;
    }

    public void setWelcomePages(List welcomePages) {
        this.doSet("welcomePages", welcomePages);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("documentRoot");
        this.assertNotNull("welcomePages");
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this.rootFolder = root.getFolder((IPath)new Path(this.getDocumentRoot()));
        }
        catch (Exception ex) {
            throw new ValidationException("Error while computing documentRoot", (Throwable)ex);
        }
        if (!this.rootFolder.exists()) {
            try {
                this.rootFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                throw new ValidationException("Error while creating documentRoot " + this.getDocumentRoot(), (Throwable)ex);
            }
        }
        if (!(this.rootFolder instanceof IFolder)) {
            throw new ValidationException("documentRoot is not a directory");
        }
        try {
            this.rootFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            throw new ValidationException("Error while refreshing documentRoot", (Throwable)ex);
        }
    }

    protected void deactivate() throws Exception {
        this.documentRoot = null;
        this.rootFolder = null;
        this.welcomePages = null;
        super.deactivate();
    }
}

