/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.merge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class EMFCompareEObjectCopier
extends EcoreUtil.Copier {
    private static final long serialVersionUID = 2701874812215174395L;
    private final transient DiffModel diffModel;
    private final List<ResourceDependencyChange> dependencyChanges = new ArrayList<ResourceDependencyChange>();

    public EMFCompareEObjectCopier(DiffModel diff) {
        this.diffModel = diff;
        if (this.diffModel.eContainer() instanceof DiffResourceSet) {
            for (EObject child : this.diffModel.eContainer().eContents()) {
                if (!(child instanceof ResourceDependencyChange)) continue;
                this.dependencyChanges.add((ResourceDependencyChange)child);
            }
        }
    }

    public void copyReferences() {
        HashSet entrySetCopy = new HashSet(this.entrySet());
        for (Map.Entry entry : entrySetCopy) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            EClass eClass = eObject.eClass();
            int j = 0;
            while (j < eClass.getFeatureCount()) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j);
                if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived()) {
                    if (eStructuralFeature instanceof EReference) {
                        EReference eReference = (EReference)eStructuralFeature;
                        if (!eReference.isContainment() && !eReference.isContainer()) {
                            this.copyReference(eReference, eObject, copyEObject);
                        }
                    } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                        this.copyFeatureMap(eObject, eStructuralFeature);
                    }
                }
                ++j;
            }
        }
    }

    public EObject copyReferenceValue(EReference targetReference, EObject target, EObject value) {
        EObject copy;
        EObject targetValue = (EObject)this.get(value);
        if (targetValue != null) {
            copy = (EObject)this.get(value);
        } else if (this.mergeLinkedDiff(value)) {
            copy = (EObject)this.get(value);
        } else {
            throw new EMFCompareException(EMFCompareDiffMessages.getString("EMFCompareEObjectCopier.MergeFailure", value, targetReference));
        }
        ((List)target.eGet((EStructuralFeature)targetReference)).add(copy);
        return copy;
    }

    public EObject copyReferenceValue(EReference targetReference, EObject target, EObject value, EObject matchedValue) {
        EObject actualValue = value;
        if (value == null && matchedValue != null) {
            this.handleLinkedResourceDependencyChange(matchedValue);
            actualValue = (EObject)this.get(matchedValue);
        }
        if (matchedValue != null) {
            this.put(actualValue, matchedValue);
            ((List)target.eGet((EStructuralFeature)targetReference)).add(matchedValue);
            return matchedValue;
        }
        return this.copyReferenceValue(targetReference, target, actualValue);
    }

    public void copyXMIIDs() {
        for (Map.Entry entry : this.entrySet()) {
            EObject original = (EObject)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            if (!(original.eResource() instanceof XMIResource) || !(copy.eResource() instanceof XMIResource)) continue;
            XMIResource originResource = (XMIResource)original.eResource();
            XMIResource copyResource = (XMIResource)copy.eResource();
            if (originResource.getID(original) == null) continue;
            copyResource.setID(copy, originResource.getID(original));
        }
    }

    public DiffModel getDiffModel() {
        return this.diffModel;
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (!eObject.eIsSet((EStructuralFeature)eReference)) {
            return;
        }
        if (eReference.isMany()) {
            List referencedObjectsList = (List)eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
            if (referencedObjectsList == null) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
            } else if (referencedObjectsList.size() == 0) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), (Object)referencedObjectsList);
            } else {
                for (Object referencedEObject : referencedObjectsList) {
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject != null) {
                        ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(copyReferencedEObject);
                        continue;
                    }
                    if (!this.mergeLinkedDiff((EObject)referencedEObject)) continue;
                    ((List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference))).add(this.get(referencedEObject));
                }
            }
        } else {
            Object referencedEObject = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
            if (referencedEObject == null) {
                copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), null);
            } else {
                Object copyReferencedEObject = this.get(referencedEObject);
                if (copyReferencedEObject != null) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), copyReferencedEObject);
                } else if (this.mergeLinkedDiff((EObject)referencedEObject)) {
                    copyEObject.eSet(this.getTarget((EStructuralFeature)eReference), this.get(referencedEObject));
                }
            }
        }
    }

    private void copyFeatureMap(EObject eObject, EStructuralFeature eStructuralFeature) {
        FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
        FeatureMap copyFeatureMap = (FeatureMap)((EObject)this.get(eObject)).eGet(this.getTarget(eStructuralFeature));
        int copyFeatureMapSize = copyFeatureMap.size();
        int k = 0;
        while (k < featureMap.size()) {
            block5: {
                block6: {
                    Object copyReferencedEObject;
                    EStructuralFeature feature;
                    block7: {
                        feature = featureMap.getEStructuralFeature(k);
                        if (!(feature instanceof EReference)) break block6;
                        Object referencedEObject = featureMap.getValue(k);
                        copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject != null || referencedEObject == null) break block7;
                        EReference reference = (EReference)feature;
                        if (!this.useOriginalReferences || reference.isContainment() || reference.getEOpposite() != null) break block5;
                        copyReferencedEObject = referencedEObject;
                    }
                    if (!copyFeatureMap.add(feature, copyReferencedEObject)) {
                        int l = 0;
                        while (l < copyFeatureMapSize) {
                            if (copyFeatureMap.getEStructuralFeature(l) == feature && copyFeatureMap.getValue(l) == copyReferencedEObject) {
                                copyFeatureMap.move(copyFeatureMap.size() - 1, l);
                                --copyFeatureMapSize;
                                break block5;
                            }
                            ++l;
                        }
                    }
                    break block5;
                }
                copyFeatureMap.add((Object)((FeatureMap.Entry)featureMap.get(k)));
            }
            ++k;
        }
    }

    private void handleLinkedResourceDependencyChange(EObject element) {
        for (ResourceDependencyChange dependencyChange : new ArrayList<ResourceDependencyChange>(this.dependencyChanges)) {
            Resource resource = ((EObject)dependencyChange.getRoots().get(0)).eResource();
            if (resource != element.eResource() || dependencyChange.eContainer() == null) continue;
            EcoreUtil.remove((EObject)dependencyChange);
            this.dependencyChanges.remove(dependencyChange);
            this.put(element, element);
            break;
        }
    }

    private boolean mergeLinkedDiff(EObject element) {
        boolean hasMerged = false;
        TreeIterator diffIterator = this.diffModel.eAllContents();
        while (diffIterator.hasNext()) {
            EObject next = (EObject)diffIterator.next();
            if (next instanceof ModelElementChangeLeftTarget) {
                if (((ModelElementChangeLeftTarget)next).getLeftElement() != element) continue;
                MergeService.merge((ModelElementChangeLeftTarget)next, true);
                hasMerged = true;
                break;
            }
            if (!(next instanceof ModelElementChangeRightTarget) || ((ModelElementChangeRightTarget)next).getRightElement() != element) continue;
            MergeService.merge((ModelElementChangeRightTarget)next, false);
            hasMerged = true;
            break;
        }
        return hasMerged;
    }
}

