/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.server.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.core.Acceptor;
import org.eclipse.net4j.core.Net4jCorePlugin;
import org.eclipse.net4j.examples.server.internal.IBackendInitializer;
import org.eclipse.net4j.spring.Container;
import org.eclipse.net4j.spring.ContainerCreationException;
import org.eclipse.net4j.spring.impl.ContainerImpl;
import org.eclipse.net4j.util.eclipse.AbstractPlugin;
import org.eclipse.net4j.util.eclipse.Element;
import org.eclipse.net4j.util.eclipse.ExecutableElement;
import org.eclipse.net4j.util.eclipse.ListExtensionParser;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleServerPlugin
extends AbstractPlugin {
    private static final Logger logger = Logger.getLogger(ExampleServerPlugin.class);
    public static final String PLUGIN_ID = "org.eclipse.net4j.examples.server";
    public static final String EXTENSION_POINT_ID = "backends";
    public static final String CONTEXT_PATH = "META-INF/";
    private static ExampleServerPlugin plugin;
    private List<BackendElement> backendElements = new ArrayList<BackendElement>();
    private static Container container;
    private Acceptor acceptor;

    public ExampleServerPlugin() {
        if (plugin == null) {
            plugin = this;
        }
    }

    public static ExampleServerPlugin getDefault() {
        return plugin;
    }

    protected void doStart() throws Exception {
        BackendExtensionParser mappingParser = new BackendExtensionParser(this.backendElements);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.net4j.examples.server.backends");
        mappingParser.parse(point);
    }

    protected void doStop() throws Exception {
        this.stopServer();
        plugin = null;
    }

    public synchronized boolean startServer() throws Exception {
        if (this.acceptor != null) {
            return false;
        }
        Net4jCorePlugin.getDefault();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Net4j container");
        }
        Container net4jContainer = ExampleServerPlugin.getNet4jContainer();
        for (BackendElement element : this.backendElements) {
            element.initializeBackend(net4jContainer);
        }
        this.acceptor = (Acceptor)net4jContainer.getBean("acceptor", Acceptor.class);
        this.acceptor.start();
        return true;
    }

    public synchronized boolean stopServer() throws Exception {
        if (this.acceptor == null) {
            return false;
        }
        try {
            this.acceptor.stop();
            this.acceptor = null;
        }
        catch (Exception exception) {}
        for (BackendElement element : this.backendElements) {
            try {
                element.disposeBackend();
            }
            catch (Exception exception) {}
        }
        if (container != null) {
            try {
                container.stop();
                container = null;
            }
            catch (Exception exception) {}
            container = null;
        }
        return true;
    }

    public Acceptor getAcceptor() throws Exception {
        this.startServer();
        return this.acceptor;
    }

    public List<BackendElement> getBackendElements() {
        return this.backendElements;
    }

    public static Container getNet4jContainer() {
        if (container == null) {
            String baseResourcePath;
            try {
                baseResourcePath = ExampleServerPlugin.getBundleLocation((Bundle)ExampleServerPlugin.getDefault().getBundle());
            }
            catch (IOException ex) {
                throw new ContainerCreationException("Error while computing location of bundle " + ExampleServerPlugin.getDefault().getBundle(), (Throwable)ex);
            }
            String location = "META-INF/net4j.xml";
            String name = "net4j";
            Container parent = null;
            ClassLoader classLoader = ExampleServerPlugin.getDefault().getClassLoader();
            container = new ContainerImpl(baseResourcePath, location, name, parent, classLoader);
        }
        return container;
    }

    public static class BackendElement
    extends ExecutableElement {
        protected String name;
        protected Container container;

        public String getName() {
            return this.name;
        }

        public void setName(String url) {
            this.name = url;
        }

        public Container getContainer() {
            return this.container;
        }

        public void initializeBackend(Container parent) throws CoreException {
            IBackendInitializer initializer = this.createInitializer();
            this.container = initializer.initializeContainer(this.name, parent);
        }

        public void disposeBackend() {
            if (this.container != null) {
                this.container.stop();
                this.container = null;
            }
        }

        public String toString() {
            return "Backend(" + this.name + ", " + this.className + ")";
        }

        private IBackendInitializer createInitializer() throws CoreException {
            return (IBackendInitializer)this.createExecutableExtension();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackendExtensionParser
    extends ListExtensionParser {
        public BackendExtensionParser(List<BackendElement> list) {
            super(list);
            this.addFactory("backend", new Element.Factory(){

                public Element createElementData() {
                    return new BackendElement();
                }
            });
        }
    }
}

