/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.net4j.core.Protocol;
import org.eclipse.net4j.core.ProtocolManager;
import org.eclipse.net4j.spring.impl.ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolManagerImpl
extends ServiceImpl
implements ProtocolManager {
    protected static final int INITIAL_CAPACITY = 23;
    protected List<Protocol> protocols = new ArrayList<Protocol>();
    protected HashMap<String, Protocol> serverProtocols = new HashMap(23);
    protected HashMap<String, Protocol> clientProtocols = new HashMap(23);
    protected int protocolCount;

    @Override
    public Protocol lookupClient(String name) {
        return this.clientProtocols.get(name);
    }

    @Override
    public Protocol lookupServer(String name) {
        return this.serverProtocols.get(name);
    }

    @Override
    public void deregister(Protocol protocol) {
    }

    @Override
    public void register(Protocol protocol) {
        String name = protocol.getName();
        this.protocols.add(protocol);
        if (protocol.isServer()) {
            if (this.isDebugEnabled()) {
                this.debug("Registering server-side protocol: " + name);
            }
            this.serverProtocols.put(name, protocol);
            if (this.clientProtocols.get(name) == null) {
                ++this.protocolCount;
            }
        }
        if (protocol.isClient()) {
            if (this.isDebugEnabled()) {
                this.debug("Registering client-side protocol: " + name);
            }
            this.clientProtocols.put(name, protocol);
            if (this.serverProtocols.get(name) == null) {
                ++this.protocolCount;
            }
        }
    }

    @Override
    public Iterator<Protocol> getClientProtocols() {
        return this.clientProtocols.values().iterator();
    }

    @Override
    public Iterator<Protocol> getServerProtocols() {
        return this.serverProtocols.values().iterator();
    }

    public int getProtocolCount() {
        return this.protocolCount;
    }

    protected void deactivate() throws Exception {
        this.clientProtocols = null;
        this.protocols = null;
        this.serverProtocols = null;
        super.deactivate();
    }
}

