/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Protocol;
import org.eclipse.net4j.core.ProtocolManager;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.ImplementationError;

public abstract class AbstractProtocol
extends ServiceImpl
implements Protocol {
    private ProtocolManager protocolManager;
    private Set<Channel> channels = new HashSet<Channel>();

    public static String typeString(int type) {
        switch (type) {
            case 1: {
                return "server";
            }
            case 2: {
                return "client";
            }
            case 3: {
                return "symmetric";
            }
        }
        throw new ImplementationError("Invalid type: " + type);
    }

    public String getTypeString() {
        return AbstractProtocol.typeString(this.getType());
    }

    public boolean isClient() {
        return (this.getType() & 2) > 0;
    }

    public boolean isServer() {
        return (this.getType() & 1) > 0;
    }

    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public void setProtocolManager(ProtocolManager protocolManager) {
        this.doSet("protocolManager", protocolManager);
    }

    public Channel[] getChannels() {
        return this.channels.toArray(new Channel[this.channels.size()]);
    }

    public void registerChannel(Channel channel) throws Exception {
        if (this.channels != null) {
            this.channels.add(channel);
        }
    }

    public void deregisterChannel(Channel channel) throws Exception {
        if (this.channels != null) {
            this.channels.remove(channel);
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("protocolManager");
    }

    protected void activate() throws Exception {
        this.protocolManager.register(this);
    }

    protected void deactivate() throws Exception {
        this.protocolManager.deregister(this);
        this.protocolManager = null;
        this.channels = null;
    }
}

