/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.core.BufferPool;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.ConnectionManager;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.Negotiator;
import org.eclipse.net4j.core.NoControlProtocolException;
import org.eclipse.net4j.core.Protocol;
import org.eclipse.net4j.core.ProtocolManager;
import org.eclipse.net4j.core.UnknownProtocolException;
import org.eclipse.net4j.core.impl.BufferImpl;
import org.eclipse.net4j.core.protocol.ChannelDeregistrationRequest;
import org.eclipse.net4j.core.protocol.ChannelRegistrationRequest;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.UnderlyingIOException;

public abstract class AbstractConnector
extends ServiceImpl
implements Connector {
    private BufferPool bufferPool;
    private Negotiator negotiator;
    private ConnectionManager connectionManager;
    private ProtocolManager protocolManager;
    private String userName;
    private transient List<Channel> channels = new ArrayList<Channel>();

    public Negotiator getNegotiator() {
        return this.negotiator;
    }

    public void setNegotiator(Negotiator negotiator) {
        this.doSet("negotiator", negotiator);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.doSet("connectionManager", connectionManager);
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void setBufferPool(BufferPool bufferPool) {
        this.doSet("bufferPool", bufferPool);
    }

    public ProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public void setProtocolManager(ProtocolManager protocolManager) {
        this.doSet("protocolManager", protocolManager);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.doSet("userName", userName);
    }

    public boolean isAuthenticated() {
        return this.userName != null;
    }

    public Channel addChannel(String protocolName) {
        Protocol protocol = this.findProtocol(protocolName);
        boolean withSignal = true;
        if (this.channels.isEmpty()) {
            if (protocolName.equals("control")) {
                withSignal = false;
            } else {
                throw new NoControlProtocolException();
            }
        }
        Channel channel = this.createChannel(protocol);
        if (withSignal) {
            Channel controlChannel = this.getChannel(0);
            ChannelRegistrationRequest signal = new ChannelRegistrationRequest(protocolName);
            try {
                controlChannel.transmit(signal);
            }
            catch (Exception ex) {
                this.error("Problem while requesting signal " + signal + " through channel " + controlChannel, ex);
                return null;
            }
        }
        return channel;
    }

    public void removeChannel(Channel channel) {
        Channel controlChannel;
        short channelIndex = channel.getChannelIndex();
        if (channelIndex != 0 && this.isClient() && (controlChannel = this.getChannel(0)) != null) {
            ChannelDeregistrationRequest signal = new ChannelDeregistrationRequest(channelIndex);
            try {
                controlChannel.transmit(signal);
            }
            catch (Exception ex) {
                this.error("Problem while requesting signal " + signal + " through channel " + controlChannel, ex);
            }
        }
        this.channels.set(channelIndex, null);
    }

    public Channel[] getChannels(String protocolName) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (Channel channel : this.channels) {
            Protocol protocol = channel.getProtocol();
            if (protocol == null || !protocol.getName().equals(protocolName)) continue;
            list.add(channel);
        }
        return list.toArray(new Channel[list.size()]);
    }

    public Channel[] getChannels() {
        return this.channels.toArray(new Channel[this.channels.size()]);
    }

    public Channel getChannel(int id) {
        if (id == 0 && this.channels.size() == 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new UnderlyingIOException((Throwable)ex);
            }
        }
        return this.channels.get(id);
    }

    public boolean isClient() {
        return this.getType() == 0;
    }

    public boolean isServer() {
        return this.getType() == 1;
    }

    public String getTypeString() {
        return AbstractConnector.getTypeString(this.getType());
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 1: {
                return "server";
            }
            case 0: {
                return "client";
            }
        }
        throw new ImplementationError("Invalid type: " + type);
    }

    protected short findFreeChannelIndex() {
        short s = this.channels.size();
        short i = 0;
        while (i < s) {
            if (this.channels.get(i) == null) {
                return i;
            }
            i = (short)(i + 1);
        }
        this.channels.add(null);
        return s;
    }

    public Protocol findProtocol(String protocolName) {
        Protocol protocol = null;
        if (this.isServer()) {
            protocol = this.protocolManager.lookupServer(protocolName);
        } else if (this.isClient()) {
            protocol = this.protocolManager.lookupClient(protocolName);
        } else {
            throw new ImplementationError("Connector is neither server nor client");
        }
        if (protocol == null) {
            throw new UnknownProtocolException("Protocol " + protocolName + " is not registered with " + (this.isServer() ? "server" : "client"));
        }
        return protocol;
    }

    public Channel createChannel(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        try {
            short channelIndex = this.findFreeChannelIndex();
            if (this.isDebugEnabled()) {
                this.debug("Adding " + protocol.getName() + " channel");
            }
            Channel channel = (Channel)this.getContainer().getBean("channel");
            channel.setConnector(this);
            channel.setProtocol(protocol);
            channel.setChannelIndex(channelIndex);
            this.channels.set(channelIndex, channel);
            channel.start();
            return channel;
        }
        catch (Exception ex) {
            this.error("Error while creating channel for protocol " + protocol, ex);
            return null;
        }
    }

    public void releaseBuffer(BufferImpl buffer) {
        this.bufferPool.releaseBuffer(buffer);
    }

    public void adjustTransmitterBuffer(BufferImpl transmitterBuffer) {
    }

    protected void dump(boolean withInternals) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("type = " + (this.isServer() ? "SERVER" : "CLIENT"));
        super.dump(withInternals, attributes);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("bufferPool");
        this.assertNotNull("protocolManager");
        if (this.isServer()) {
            this.assertNotNull("connectionManager");
        }
    }

    protected void activate() throws Exception {
        super.activate();
        if (this.negotiator != null) {
            this.negotiator.negotiate(this);
        }
        this.addChannel("control");
        if (this.isServer()) {
            this.connectionManager.registerConnector(this);
        }
    }

    protected void deactivate() throws Exception {
        if (this.isServer()) {
            this.connectionManager.deregisterConnector(this);
        }
        int i = 0;
        while (i < this.channels.size()) {
            Channel channel = this.channels.get(i);
            if (channel != null) {
                channel.stop();
            }
            i = (short)(i + 1);
        }
        this.bufferPool = null;
        this.channels = null;
        this.connectionManager = null;
        this.negotiator = null;
        this.protocolManager = null;
        this.userName = null;
        super.deactivate();
    }
}

