/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.codegen.engine;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.search.codegen.Activator;
import org.eclipse.emf.search.codegen.constants.GenConstants;
import org.eclipse.emf.search.codegen.engine.AbstractModelSearchCodeGenerator;
import org.eclipse.emf.search.codegen.jet.DefaultJETEmitter;
import org.eclipse.emf.search.codegen.l10n.Messages;
import org.eclipse.emf.search.codegen.model.generator.ModelSearchGenSettings;
import org.osgi.framework.Bundle;

public abstract class AbstractModelSearchGenerator
extends AbstractModelSearchCodeGenerator {
    protected ModelSearchGenSettings settings;
    protected IProject generatedProject;

    public AbstractModelSearchGenerator(ModelSearchGenSettings modelSearchGeneratorInput) {
        this.settings = modelSearchGeneratorInput;
    }

    public IProject getGeneratedProject() {
        return this.generatedProject;
    }

    public Diagnostic generate(Monitor monitor) throws CoreException, JETException {
        try {
            this.generatePluginProject(monitor);
            this.processTemplatesDir(this.getCodegenBundle(), new PathEntry(this.getCodegenBundle(), this.getTemplatesDirectory()), monitor);
        }
        catch (JETException e) {
            e.printStackTrace();
            throw e;
        }
        return Diagnostic.OK_INSTANCE;
    }

    public abstract String getTemplatesDirectory();

    protected abstract String getProjectIDSuffix();

    protected IPath getBasePackagePath() {
        String basePackageName = new String(this.getProjectIDSuffix());
        return new Path(basePackageName.replace('.', '/'));
    }

    private Bundle getCodegenBundle() {
        return Activator.getDefault().getBundle();
    }

    private void processIconsDir(Bundle templatesBundle, PathEntry pathEntry, Monitor monitor) throws CoreException, JETException {
        Enumeration entries = templatesBundle.findEntries(pathEntry.getPathEntry(), "*.gif", false);
        while (entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            String entryPath = url.toString();
            if (!entryPath.toLowerCase().endsWith("gif") && !entryPath.toLowerCase().endsWith("jpg") && !entryPath.toLowerCase().endsWith("jpeg") && !entryPath.toLowerCase().endsWith("png")) continue;
            PathEntry entry = new PathEntry(pathEntry.getBundle(), entryPath);
            try {
                IFile file = this.getGeneratedProject().getFolder("icons").getFile(entry.getPath().lastSegment());
                file.create(FileLocator.resolve((URL)url).openStream(), 1, BasicMonitor.toIProgressMonitor((Monitor)monitor));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void processTemplatesDir(Bundle templatesBundle, PathEntry pathEntry, Monitor monitor) throws CoreException, JETException {
        Enumeration entries = templatesBundle.getEntryPaths(pathEntry.getPathEntry());
        while (entries.hasMoreElements()) {
            PathEntry entry = new PathEntry(pathEntry.getBundle(), entries.nextElement().toString());
            if (entry.isFolder()) {
                if ("cvs".equals(entry.getName().toLowerCase())) continue;
                if ("icons".equals(entry.getName().toLowerCase())) {
                    this.createFolder(this.getGeneratedProject(), entry, monitor);
                    this.processIconsDir(templatesBundle, entry, monitor);
                    continue;
                }
                monitor.subTask(String.valueOf(Messages.getString("AbstractModelSearchGenerator.GenDirectoriesLabel")) + entry.getPathEntry() + Messages.getString("AbstractModelSearchGenerator.GenDirectoriesText"));
                this.createFolder(this.getGeneratedProject(), entry, monitor);
                if (entry.isSourceDirectory()) {
                    this.createBasePackage(this.getGeneratedProject(), entry, monitor);
                }
                monitor.worked(1);
                this.processTemplatesDir(templatesBundle, entry, monitor);
                continue;
            }
            this.processTemplateFile(this.getGeneratedProject(), pathEntry, entry, monitor);
        }
    }

    private IPath constructFullTargetPath(IProject targetProject, PathEntry pathEntry) {
        String fileExtension;
        IPath targetProjectPath;
        IPath resultPath = targetProjectPath = targetProject.getFullPath();
        if (pathEntry.isSourceEntry()) {
            String srcPath = pathEntry.getRelativeTo(String.valueOf(this.getTemplatesDirectory()) + '/' + GenConstants.SRC_DIRECTORY_SUFFIX + '/');
            resultPath = resultPath.append(String.valueOf('/') + GenConstants.SRC_DIRECTORY_SUFFIX).append(this.getBasePackagePath()).append(srcPath);
        } else {
            resultPath = resultPath.append(String.valueOf('/') + pathEntry.getRelativeTo(this.getTemplatesDirectory()));
        }
        if (resultPath.getFileExtension() != null && (fileExtension = resultPath.getFileExtension()).lastIndexOf("jet") != -1) {
            return resultPath.removeFileExtension().addFileExtension(fileExtension.substring(0, fileExtension.lastIndexOf("jet")));
        }
        return resultPath;
    }

    private void createFolder(IProject targetProject, PathEntry folderEntry, Monitor monitor) throws CoreException {
        IFolder targetFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.constructFullTargetPath(targetProject, folderEntry));
        if (!targetFolder.exists()) {
            targetFolder.create(true, false, BasicMonitor.toIProgressMonitor((Monitor)monitor));
        }
    }

    private void createBasePackage(IProject targetProject, PathEntry srcDirectoryEntry, Monitor monitor) throws CoreException {
        String basePackageName = new String(this.getProjectIDSuffix());
        IPath targetSrcPath = this.constructFullTargetPath(targetProject, srcDirectoryEntry);
        Path basePackagePath = new Path(basePackageName.replace('.', '/'));
        int i = 1;
        while (i < basePackagePath.segmentCount() + 1) {
            IPath packagePath = targetSrcPath.append(basePackagePath.removeLastSegments(basePackagePath.segmentCount() - i));
            IFolder packageFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(packagePath);
            if (!packageFolder.exists()) {
                packageFolder.create(true, false, BasicMonitor.toIProgressMonitor((Monitor)monitor));
            }
            ++i;
        }
    }

    private void processTemplateFile(IProject targetProject, PathEntry templateFolder, PathEntry templatePath, Monitor monitor) throws CoreException, JETException {
        IFile targetFile;
        IPath targetFilePath = this.constructFullTargetPath(targetProject, templatePath);
        if (!templatePath.isMergeable() && (targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetFilePath)).exists()) {
            String targetFileName = targetFile.getName();
            String targetFileExtension = targetFile.getFileExtension();
            String toMergeFileName = String.valueOf(targetFileName.substring(0, targetFileName.lastIndexOf(targetFileExtension))) + "ToMerge" + targetFileExtension;
            targetFilePath = targetFilePath.removeLastSegments(1).append(toMergeFileName);
        }
        this.applyTemplate(this.settings, templatePath.getURI().toString(), targetFilePath, false, monitor);
    }

    protected JETEmitter createJETEmitter(String templateURI) {
        return new DefaultJETEmitter(templateURI){

            public void initialize(Monitor monitor) throws JETException {
                this.addVariable("MODEL_SEARCH_PLUGIN", "org.eclipse.emf.search");
                this.addVariable("MODEL_SEARCH_PLUGIN_UI", "org.eclipse.emf.search.ui");
                this.addVariable("MODEL_SEARCH_ECORE_PLUGIN", "org.eclipse.emf.search.ecore");
                this.addVariable("MODEL_SEARCH_ECORE_PLUGIN_UI", "org.eclipse.emf.search.ecore.ui");
                this.addVariable("MODEL_SEARCH_CODEGEN_PLUGIN", "org.eclipse.emf.search.codegen");
                if (Platform.getOS().equals("macosx")) {
                    this.addVariable("SWT", "org.eclipse.swt." + Platform.getWS() + "." + Platform.getOS());
                } else {
                    this.addVariable("SWT", "org.eclipse.swt." + Platform.getWS() + "." + Platform.getOS() + "." + Platform.getOSArch());
                }
                super.initialize(monitor);
            }
        };
    }

    public static IPath getPackageIPath(String packageName) {
        return new Path(new String(packageName).replace('.', '/'));
    }

    private Diagnostic generatePluginProject(Monitor monitor) throws JETException, CoreException {
        IProject project;
        monitor.subTask(Messages.getString("AbstractModelSearchGenerator.GenProjects"));
        this.generatedProject = project = AbstractModelSearchGenerator.createEMFProject(String.valueOf(this.settings.getGenModel().getModelPluginID()) + new String(this.getProjectIDSuffix()));
        monitor.worked(1);
        return Diagnostic.OK_INSTANCE;
    }

    public ModelSearchGenSettings getSettings() {
        return this.settings;
    }

    private class PathEntry {
        static final String XML_EXTENSION = "xmljet";
        static final String PROPERTIES_EXTENSION = "propertiesjet";
        static final String MF_EXTENSION = "mfjet";
        static final String JAVA_EXTENSION = "javajet";
        static final int XML_TYPE = 1;
        static final int PROPERTIES_TYPE = 2;
        static final int MF_TYPE = 3;
        static final int JAVA_TYPE = 4;
        static final int UNKNOWN_TYPE = 0;
        static final int FOLDER_TYPE = -1;
        private Bundle bundle;
        private String pathEntry;

        public PathEntry(Bundle bundle, String pathEntry) {
            this.bundle = bundle;
            this.pathEntry = pathEntry;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String getPathEntry() {
            return this.pathEntry;
        }

        public IPath getPath() {
            return new Path(this.pathEntry);
        }

        public String getName() {
            return this.getPath().lastSegment();
        }

        public String getRelativeTo(String anotherEntry) {
            Path entryPath = new Path(this.pathEntry);
            Path anotherEntryPath = new Path(anotherEntry);
            return entryPath.removeFirstSegments(entryPath.matchingFirstSegments((IPath)anotherEntryPath)).toOSString();
        }

        public boolean isFolder() {
            return this.pathEntry != null && this.pathEntry.endsWith("/");
        }

        public boolean isSourceDirectory() {
            return this.isFolder() && GenConstants.SRC_DIRECTORY_SUFFIX.equals(this.getPath().lastSegment());
        }

        public boolean isSourceEntry() {
            return !GenConstants.SRC_DIRECTORY_SUFFIX.equals(this.getPath().lastSegment()) && this.getPathEntry().startsWith(String.valueOf(AbstractModelSearchGenerator.this.getTemplatesDirectory()) + '/' + GenConstants.SRC_DIRECTORY_SUFFIX);
        }

        public boolean isTemplate() {
            return !this.isFolder() && this.getPath().getFileExtension().toLowerCase().endsWith("jet");
        }

        private int getType() {
            if (this.isFolder()) {
                return -1;
            }
            String fileExtension = this.getPath().getFileExtension().toLowerCase();
            if (XML_EXTENSION.equals(fileExtension)) {
                return 1;
            }
            if (PROPERTIES_EXTENSION.equals(fileExtension)) {
                return 2;
            }
            if (MF_EXTENSION.equals(fileExtension)) {
                return 3;
            }
            if (JAVA_EXTENSION.equals(fileExtension)) {
                return 4;
            }
            return 0;
        }

        public boolean isMergeable() {
            int fileType = this.getType();
            return fileType == 4 || fileType == 2;
        }

        public URL getURI() {
            return this.getBundle().getEntry(this.getPathEntry());
        }
    }
}

