/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui;

import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.examples.ui.internal.ExampleUIActivator;
import org.eclipse.emf.cdo.examples.ui.internal.editors.CDOEditorInput;
import org.eclipse.emf.cdo.examples.ui.internal.wizards.CDOExportWizard;
import org.eclipse.emf.cdo.examples.ui.internal.wizards.CDOImportWizard;
import org.eclipse.emf.cdo.examples.ui.internal.wizards.CDONewWizard;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class UIUtils {
    public static void openCDONewWizard(ResourceManager resourceManager, boolean commit) {
        UIUtils.openWizard((IWorkbenchWizard)new CDONewWizard(resourceManager, commit));
    }

    public static void openCDONewWizard() {
        UIUtils.openCDONewWizard(null, true);
    }

    public static void openCDOImportWizard(ResourceManager resourceManager, boolean commit) {
        UIUtils.openWizard((IWorkbenchWizard)new CDOImportWizard(resourceManager, commit));
    }

    public static void openCDOImportWizard() {
        UIUtils.openCDOImportWizard(null, true);
    }

    public static void openCDOExportWizard(CDOResource resource) {
        UIUtils.openWizard((IWorkbenchWizard)new CDOExportWizard(resource));
    }

    public static void openCDOExportWizard() {
        UIUtils.openWizard((IWorkbenchWizard)new CDOExportWizard());
    }

    public static IEditorPart openCDOEditor(ResourceInfo resourceInfo) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        try {
            return activePage.openEditor((IEditorInput)new CDOEditorInput(resourceInfo), "org.eclipse.emf.cdo.examples.ui.Editor");
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)new Shell(), (String)"CDO Explorer", (String)("Can't open CDO Editor for " + resourceInfo));
            return null;
        }
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ExtendedImageRegistry.getInstance().getImageDescriptor(ExampleUIActivator.INSTANCE.getImage(key));
    }

    public static Image getImage(String key) {
        return ExtendedImageRegistry.getInstance().getImage(ExampleUIActivator.INSTANCE.getImage(key));
    }

    public static void refreshViewer(final Viewer viewer) {
        Display display = viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (viewer != null && !viewer.getControl().isDisposed()) {
                    try {
                        viewer.refresh();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public static void refreshPropertySheetPage(IPropertySheetPage propertySheetPage) {
        if (propertySheetPage instanceof PropertySheetPage) {
            final PropertySheetPage page = (PropertySheetPage)propertySheetPage;
            Display display = page.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (page != null && !page.getControl().isDisposed()) {
                        try {
                            page.refresh();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private static void openWizard(IWorkbenchWizard wizard) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IStructuredSelection selection = page.getSelection() instanceof IStructuredSelection ? (IStructuredSelection)page.getSelection() : null;
        wizard.init(workbench, selection);
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }
}

