/**
 * <copyright>
 * </copyright>
 *
 * $Id: AttributesValidator.java,v 1.1 2009/07/23 11:16:29 mtaal Exp $
 */
package org.eclipse.emf.teneo.jpa.orm.validation;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.teneo.jpa.orm.Basic;
import org.eclipse.emf.teneo.jpa.orm.Embedded;
import org.eclipse.emf.teneo.jpa.orm.EmbeddedId;
import org.eclipse.emf.teneo.jpa.orm.Id;
import org.eclipse.emf.teneo.jpa.orm.ManyToMany;
import org.eclipse.emf.teneo.jpa.orm.ManyToOne;
import org.eclipse.emf.teneo.jpa.orm.OneToMany;
import org.eclipse.emf.teneo.jpa.orm.OneToOne;
import org.eclipse.emf.teneo.jpa.orm.Transient;
import org.eclipse.emf.teneo.jpa.orm.Version;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.jpa.orm.Attributes}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface AttributesValidator {
	boolean validate();

	boolean validateId(EList<Id> value);
	boolean validateEmbeddedId(EmbeddedId value);
	boolean validateBasic(EList<Basic> value);
	boolean validateVersion(EList<Version> value);
	boolean validateManyToOne(EList<ManyToOne> value);
	boolean validateOneToMany(EList<OneToMany> value);
	boolean validateOneToOne(EList<OneToOne> value);
	boolean validateManyToMany(EList<ManyToMany> value);
	boolean validateEmbedded(EList<Embedded> value);
	boolean validateTransient(EList<Transient> value);
}
