/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.session.CDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.view.CDOAudit;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;

public class CDOAuditImpl
extends CDOViewImpl
implements CDOAudit {
    private long timeStamp;

    public CDOAuditImpl(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public CDOCommonView.Type getViewType() {
        return CDOCommonView.Type.AUDIT;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.checkActive();
        if (this.timeStamp != timeStamp) {
            List<InternalCDOObject> invalidObjects = this.getInvalidObjects(timeStamp);
            boolean[] existanceFlags = this.getSession().getSessionProtocol().setAudit(this.getViewID(), timeStamp, invalidObjects);
            this.timeStamp = timeStamp;
            int i = 0;
            for (InternalCDOObject invalidObject : invalidObjects) {
                boolean existanceFlag;
                if (existanceFlag = existanceFlags[i++]) {
                    CDOStateMachine.INSTANCE.invalidate(invalidObject, 0);
                    continue;
                }
                CDOStateMachine.INSTANCE.detachRemote(invalidObject);
            }
        }
    }

    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        InternalCDOSession session = this.getSession();
        int initialChunkSize = session.options().getCollectionLoadingPolicy().getInitialChunkSize();
        CDORevisionManager revisionManager = session.getRevisionManager();
        return (InternalCDORevision)revisionManager.getRevisionByTime(id, initialChunkSize, this.timeStamp, loadOnDemand);
    }

    public String toString() {
        return MessageFormat.format("CDOAudit({0})", this.getViewID());
    }
}

