/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.CDOElementProxy;

public class RevisionAdjuster
extends CDOFeatureDeltaVisitorImpl {
    private CDOReferenceAdjuster referenceAdjuster;
    private InternalCDORevision revision;

    public RevisionAdjuster(CDOReferenceAdjuster referenceAdjuster) {
        this.referenceAdjuster = referenceAdjuster;
    }

    public void adjustRevision(InternalCDORevision revision, CDORevisionDelta revisionDelta) {
        this.revision = revision;
        revisionDelta.accept((CDOFeatureDeltaVisitor)this);
    }

    public void visit(CDOContainerFeatureDelta delta) {
        this.revision.setContainerID(this.referenceAdjuster.adjustReference(this.revision.getContainerID()));
        this.revision.setResourceID((CDOID)this.referenceAdjuster.adjustReference((Object)this.revision.getResourceID()));
    }

    public void visit(CDOAddFeatureDelta delta) {
        this.revision.setValue(delta.getFeature(), delta.getValue());
    }

    public void visit(CDOSetFeatureDelta delta) {
        EStructuralFeature feature = delta.getFeature();
        CDORevisionImpl.checkNoFeatureMap((EStructuralFeature)feature);
        Object value = delta.getValue();
        if (value != null && feature instanceof EReference && !(value instanceof CDOElementProxy)) {
            this.revision.setValue(feature, this.referenceAdjuster.adjustReference(value));
        }
    }

    public void visit(CDOListFeatureDelta deltas) {
        EStructuralFeature feature = deltas.getFeature();
        CDORevisionImpl.checkNoFeatureMap((EStructuralFeature)feature);
        InternalCDOList list = (InternalCDOList)this.revision.getValue(feature);
        if (feature instanceof EReference) {
            int[] indices = (int[])((CDOListFeatureDeltaImpl)deltas).reconstructAddedIndices().getElement2();
            int i = 1;
            while (i <= indices[0]) {
                int index = indices[i];
                Object value = list.get(index);
                if (value != null && !(value instanceof CDOElementProxy)) {
                    value = this.referenceAdjuster.adjustReference(value);
                    list.set(index, value);
                }
                ++i;
            }
        }
    }
}

