/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.mem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.internal.server.mem.MEMStoreAccessor;
import org.eclipse.emf.cdo.server.IMEMStore;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStore
extends LongIDStore
implements IMEMStore {
    public static final String TYPE = "mem";
    private long creationTime;
    private Map<CDOID, List<InternalCDORevision>> revisions = new HashMap<CDOID, List<InternalCDORevision>>();
    private int listLimit;

    public MEMStore(int listLimit) {
        super(TYPE, MEMStore.set(IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA), MEMStore.set(IStore.RevisionTemporality.NONE, IStore.RevisionTemporality.AUDITING), MEMStore.set(IStore.RevisionParallelism.NONE));
        this.setRevisionTemporality(IStore.RevisionTemporality.AUDITING);
        this.listLimit = listLimit;
    }

    public MEMStore() {
        this(-1);
    }

    @Override
    public int getListLimit() {
        return this.listLimit;
    }

    @Override
    public synchronized void setListLimit(int listLimit) {
        if (listLimit != -1 && this.listLimit != listLimit) {
            for (List<InternalCDORevision> list : this.revisions.values()) {
                this.enforceListLimit(list);
            }
        }
        this.listLimit = listLimit;
    }

    public synchronized List<InternalCDORevision> getCurrentRevisions() {
        ArrayList<InternalCDORevision> simpleRevisions = new ArrayList<InternalCDORevision>();
        for (List<InternalCDORevision> list : this.revisions.values()) {
            InternalCDORevision revision = list.get(list.size() - 1);
            simpleRevisions.add(revision);
        }
        return simpleRevisions;
    }

    public synchronized InternalCDORevision getRevision(CDOID id) {
        List<InternalCDORevision> list = this.revisions.get(id);
        if (list != null) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public synchronized InternalCDORevision getRevisionByVersion(CDOID id, int version) {
        if (this.getRepository().isSupportingAudits()) {
            List<InternalCDORevision> list = this.revisions.get(id);
            if (list != null) {
                return this.getRevisionByVersion(list, version);
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public synchronized InternalCDORevision getRevisionByTime(CDOID id, long timeStamp) {
        if (this.getRepository().isSupportingAudits()) {
            List<InternalCDORevision> list = this.revisions.get(id);
            if (list != null) {
                return this.getRevisionByTime(list, timeStamp);
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public synchronized void addRevision(InternalCDORevision revision) {
        InternalCDORevision rev;
        CDOID id = revision.getID();
        int version = revision.getVersion();
        List<InternalCDORevision> list = this.revisions.get(id);
        if (list == null) {
            list = new ArrayList<InternalCDORevision>();
            this.revisions.put(id, list);
        }
        if ((rev = this.getRevisionByVersion(list, version)) != null) {
            throw new IllegalStateException("Concurrent modification of revision " + rev);
        }
        rev = this.getRevisionByVersion(list, version - 1);
        if (rev != null) {
            rev.setRevised(revision.getCreated() - 1L);
        }
        if (revision.isResource()) {
            EStructuralFeature feature = revision.getEClass().getEStructuralFeature("name");
            CDOID revisionFolder = (CDOID)revision.data().getContainerID();
            String revisionName = (String)revision.data().get(feature, 0);
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            CDOID resourceID = accessor.readResourceID(revisionFolder, revisionName, revision.getCreated());
            if (!CDOIDUtil.isNull((CDOID)resourceID)) {
                throw new IllegalStateException("Duplicate resource: " + revisionName + " (folderID=" + revisionFolder + ")");
            }
        }
        list.add(revision);
        if (this.listLimit != -1) {
            this.enforceListLimit(list);
        }
    }

    public synchronized boolean rollbackRevision(InternalCDORevision revision) {
        CDOID id = revision.getID();
        List<InternalCDORevision> list = this.revisions.get(id);
        if (list == null) {
            return false;
        }
        int version = revision.getVersion();
        Iterator<InternalCDORevision> it = list.iterator();
        while (it.hasNext()) {
            InternalCDORevision rev = it.next();
            if (rev.getVersion() == version) {
                it.remove();
                return true;
            }
            if (rev.getVersion() != version - 1) continue;
            rev.setRevised(0L);
        }
        return false;
    }

    public synchronized void removeID(CDOID id) {
        this.revisions.remove(id);
    }

    public synchronized void queryResources(IStoreAccessor.QueryResourcesContext context) {
        CDOID folderID = context.getFolderID();
        String name = context.getName();
        boolean exactMatch = context.exactMatch();
        for (List<InternalCDORevision> list : this.revisions.values()) {
            boolean match;
            CDOID revisionFolder;
            InternalCDORevision revision;
            if (list.isEmpty() || !(revision = list.get(0)).isResourceNode() || (revision = this.getRevisionByTime(list, context.getTimeStamp())) == null || !CDOIDUtil.equals((CDOID)(revisionFolder = (CDOID)revision.data().getContainerID()), (CDOID)folderID)) continue;
            EStructuralFeature feature = revision.getEClass().getEStructuralFeature("name");
            String revisionName = (String)revision.data().get(feature, 0);
            boolean bl = match = exactMatch || revisionName == null || name == null ? ObjectUtil.equals((Object)revisionName, (Object)name) : revisionName.startsWith(name);
            if (match && !context.addResource(revision.getID())) break;
        }
    }

    @Override
    public MEMStoreAccessor createReader(ISession session) {
        return new MEMStoreAccessor(this, session);
    }

    @Override
    public MEMStoreAccessor createWriter(ITransaction transaction) {
        return new MEMStoreAccessor(this, transaction);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean isFirstTime() {
        return true;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.creationTime = System.currentTimeMillis();
    }

    protected void doDeactivate() throws Exception {
        this.revisions.clear();
        super.doDeactivate();
    }

    @Override
    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return null;
    }

    @Override
    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return null;
    }

    private InternalCDORevision getRevisionByVersion(List<InternalCDORevision> list, int version) {
        for (InternalCDORevision revision : list) {
            if (revision.getVersion() != version) continue;
            return revision;
        }
        return null;
    }

    private InternalCDORevision getRevisionByTime(List<InternalCDORevision> list, long timeStamp) {
        for (InternalCDORevision revision : list) {
            if (!(timeStamp == 0L ? revision.isCurrent() : revision.isValid(timeStamp))) continue;
            return revision;
        }
        return null;
    }

    private void enforceListLimit(List<InternalCDORevision> list) {
        while (list.size() > this.listLimit) {
            list.remove(0);
        }
    }
}

