/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelEndPoint
extends AbstractEndPoint
implements ManagedSelector.Selectable {
    private static final Logger LOG = LoggerFactory.getLogger(SocketChannelEndPoint.class);
    private final AutoLock _lock = new AutoLock();
    private final SocketChannel _channel;
    private final ManagedSelector _selector;
    private SelectionKey _key;
    private boolean _updatePending;
    private int _currentInterestOps;
    private int _desiredInterestOps;
    private final ManagedSelector.SelectorUpdate _updateKeyAction = this::updateKeyAction;
    private final Runnable _runFillable = new RunnableCloseable("runFillable"){

        public Invocable.InvocationType getInvocationType() {
            return SocketChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
        }

        @Override
        public void run() {
            SocketChannelEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Runnable _runCompleteWrite = new RunnableCloseable("runCompleteWrite"){

        public Invocable.InvocationType getInvocationType() {
            return SocketChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType();
        }

        @Override
        public void run() {
            SocketChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        @Override
        public String toString() {
            return String.format("%s:%s:%s->%s", SocketChannelEndPoint.this, this._operation, this.getInvocationType(), SocketChannelEndPoint.this.getWriteFlusher());
        }
    };
    private final Runnable _runCompleteWriteFillable = new RunnableCloseable("runCompleteWriteFillable"){

        public Invocable.InvocationType getInvocationType() {
            Invocable.InvocationType flushT;
            Invocable.InvocationType fillT = SocketChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
            if (fillT == (flushT = SocketChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType())) {
                return fillT;
            }
            if (fillT == Invocable.InvocationType.EITHER && flushT == Invocable.InvocationType.NON_BLOCKING) {
                return Invocable.InvocationType.EITHER;
            }
            if (fillT == Invocable.InvocationType.NON_BLOCKING && flushT == Invocable.InvocationType.EITHER) {
                return Invocable.InvocationType.EITHER;
            }
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        public void run() {
            SocketChannelEndPoint.this.getWriteFlusher().completeWrite();
            SocketChannelEndPoint.this.getFillInterest().fillable();
        }
    };

    public SocketChannelEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey key, Scheduler scheduler) {
        super(scheduler);
        this._channel = channel;
        this._selector = selector;
        this._key = key;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        try {
            return this._channel.getLocalAddress();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not retrieve local socket address", x);
            }
            return null;
        }
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        try {
            return this._channel.getRemoteAddress();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not retrieve remote socket address", x);
            }
            return null;
        }
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    @Override
    protected void doShutdownOutput() {
        block3: {
            try {
                Socket socket = this._channel.socket();
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Could not shutdown output for {}", (Object)this._channel, (Object)x);
            }
        }
    }

    @Override
    public void doClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClose {}", (Object)this);
        }
        try {
            this._channel.close();
        }
        catch (IOException e) {
            LOG.debug("Unable to close channel", (Throwable)e);
        }
        finally {
            super.doClose();
        }
    }

    @Override
    public void onClose(Throwable cause) {
        try {
            super.onClose(cause);
        }
        finally {
            if (this._selector != null) {
                this._selector.destroyEndPoint(this, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        int filled;
        if (this.isInputShutdown()) {
            return -1;
        }
        int pos = BufferUtil.flipToFill((ByteBuffer)buffer);
        try {
            filled = this._channel.read(buffer);
            if (filled > 0) {
                this.notIdle();
            } else if (filled == -1) {
                this.shutdownInput();
            }
        }
        catch (IOException e) {
            LOG.debug("Unable to shutdown output", (Throwable)e);
            this.shutdownInput();
            filled = -1;
        }
        finally {
            BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filled {} {}", (Object)filled, (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
        }
        return filled;
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        long flushed;
        try {
            flushed = this._channel.write(buffers);
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", (Object)flushed, (Object)this);
            }
        }
        catch (IOException e) {
            throw new EofException(e);
        }
        if (flushed > 0L) {
            this.notIdle();
        }
        for (ByteBuffer b : buffers) {
            if (BufferUtil.isEmpty((ByteBuffer)b)) continue;
            return false;
        }
        return true;
    }

    public SocketChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    @Override
    public Runnable onSelected() {
        Runnable task;
        boolean flushable;
        int newInterestOps;
        int oldInterestOps;
        int readyOps = this._key.readyOps();
        try (AutoLock l = this._lock.lock();){
            this._updatePending = true;
            oldInterestOps = this._desiredInterestOps;
            this._desiredInterestOps = newInterestOps = oldInterestOps & ~readyOps;
        }
        boolean fillable = (readyOps & 1) != 0;
        boolean bl = flushable = (readyOps & 4) != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onSelected {}->{} r={} w={} for {}", new Object[]{oldInterestOps, newInterestOps, fillable, flushable, this});
        }
        Runnable runnable = fillable ? (flushable ? this._runCompleteWriteFillable : this._runFillable) : (task = flushable ? this._runCompleteWrite : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("task {}", (Object)task);
        }
        return task;
    }

    private void updateKeyAction(Selector selector) {
        this.updateKey();
    }

    @Override
    public void updateKey() {
        try {
            int newInterestOps;
            int oldInterestOps;
            try (AutoLock l = this._lock.lock();){
                this._updatePending = false;
                oldInterestOps = this._currentInterestOps;
                newInterestOps = this._desiredInterestOps;
                if (oldInterestOps != newInterestOps) {
                    this._currentInterestOps = newInterestOps;
                    this._key.interestOps(newInterestOps);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key interests updated {} -> {} on {}", new Object[]{oldInterestOps, newInterestOps, this});
            }
        }
        catch (CancelledKeyException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring key update for cancelled key {}", (Object)this, (Object)x);
            }
            this.close();
        }
        catch (Throwable x) {
            LOG.warn("Ignoring key update for {}", (Object)this, (Object)x);
            this.close();
        }
    }

    @Override
    public void replaceKey(SelectionKey newKey) {
        this._key = newKey;
    }

    private void changeInterests(int operation) {
        int newInterestOps;
        int oldInterestOps;
        boolean pending;
        try (AutoLock l = this._lock.lock();){
            pending = this._updatePending;
            oldInterestOps = this._desiredInterestOps;
            newInterestOps = oldInterestOps | operation;
            if (newInterestOps != oldInterestOps) {
                this._desiredInterestOps = newInterestOps;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("changeInterests p={} {}->{} for {}", new Object[]{pending, oldInterestOps, newInterestOps, this});
        }
        if (!pending && this._selector != null) {
            this._selector.submit(this._updateKeyAction);
        }
    }

    @Override
    public String toEndPointString() {
        return String.format("%s{io=%d/%d,kio=%d,kro=%d}", super.toEndPointString(), this._currentInterestOps, this._desiredInterestOps, ManagedSelector.safeInterestOps(this._key), ManagedSelector.safeReadyOps(this._key));
    }

    private abstract class RunnableCloseable
    extends RunnableTask
    implements Closeable {
        protected RunnableCloseable(String op) {
            super(op);
        }

        @Override
        public void close() {
            try {
                SocketChannelEndPoint.this.close();
            }
            catch (Throwable x) {
                LOG.warn("Unable to close {}", (Object)SocketChannelEndPoint.this, (Object)x);
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        final String _operation;

        protected RunnableTask(String op) {
            this._operation = op;
        }

        public String toString() {
            return String.format("%s:%s:%s", SocketChannelEndPoint.this, this._operation, this.getInvocationType());
        }
    }
}

