/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.eclipse.jetty.logging.JettyLevel;
import org.eclipse.jetty.logging.JettyLoggerFactory;

public class JettyLoggerConfiguration {
    private static final JettyLevel DEFAULT_LEVEL = JettyLevel.INFO;
    private static final boolean DEFAULT_HIDE_STACKS = false;
    private static final String SUFFIX_LEVEL = ".LEVEL";
    private static final String SUFFIX_STACKS = ".STACKS";
    private final Properties properties = new Properties();

    public JettyLoggerConfiguration() {
    }

    public JettyLoggerConfiguration(Properties props) {
        this.load(props);
    }

    public boolean getHideStacks(String name) {
        Boolean hideStacks;
        if (this.properties.isEmpty()) {
            return false;
        }
        String startName = name;
        while (startName.endsWith(".")) {
            startName = startName.substring(0, startName.length() - 1);
        }
        if (startName.endsWith(SUFFIX_STACKS)) {
            startName = startName.substring(0, startName.length() - SUFFIX_STACKS.length());
        }
        return (hideStacks = JettyLoggerFactory.walkParentLoggerNames(startName, key -> {
            String stacksBool = this.properties.getProperty(key + SUFFIX_STACKS);
            if (stacksBool != null) {
                return Boolean.parseBoolean(stacksBool);
            }
            return null;
        })) != null ? hideStacks : false;
    }

    public JettyLevel getLevel(String name) {
        String levelStr;
        JettyLevel level;
        String startName;
        if (this.properties.isEmpty()) {
            return DEFAULT_LEVEL;
        }
        String string = startName = name != null ? name : "";
        while (startName.endsWith(".")) {
            startName = startName.substring(0, startName.length() - 1);
        }
        if (startName.endsWith(SUFFIX_LEVEL)) {
            startName = startName.substring(0, startName.length() - SUFFIX_LEVEL.length());
        }
        if ((level = JettyLoggerFactory.walkParentLoggerNames(startName, key -> {
            String levelStr = this.properties.getProperty(key + SUFFIX_LEVEL);
            return JettyLoggerConfiguration.toJettyLevel(key, levelStr);
        })) == null) {
            levelStr = this.properties.getProperty("ROOT.LEVEL");
            level = JettyLoggerConfiguration.toJettyLevel("ROOT", levelStr);
        }
        if (level == null) {
            levelStr = this.properties.getProperty("log.LEVEL");
            level = JettyLoggerConfiguration.toJettyLevel("log", levelStr);
        }
        return level != null ? level : DEFAULT_LEVEL;
    }

    static JettyLevel toJettyLevel(String loggerName, String levelStr) {
        if (levelStr == null) {
            return null;
        }
        JettyLevel level = JettyLevel.strToLevel(levelStr);
        if (level == null) {
            System.err.printf("Unknown JettyLogger/SLF4J Level [%s]=[%s], expecting only %s as values.%n", loggerName, levelStr, Arrays.toString((Object[])JettyLevel.values()));
        }
        return level;
    }

    public TimeZone getTimeZone(String key) {
        String zoneIdStr = this.properties.getProperty(key);
        if (zoneIdStr == null) {
            return null;
        }
        return TimeZone.getTimeZone(zoneIdStr);
    }

    public JettyLoggerConfiguration load(ClassLoader loader) {
        return AccessController.doPrivileged(() -> {
            this.load(this.readProperties(loader, "jetty-logging.properties"));
            String osName = System.getProperty("os.name");
            if (osName != null && osName.length() > 0) {
                osName = osName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                this.load(this.readProperties(loader, "jetty-logging-" + osName + ".properties"));
            }
            this.load(System.getProperties());
            return this;
        });
    }

    public String getString(String key, String defValue) {
        return this.properties.getProperty(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        String val = this.properties.getProperty(key, Boolean.toString(defValue));
        return Boolean.parseBoolean(val);
    }

    public int getInt(String key, int defValue) {
        String val = this.properties.getProperty(key, Integer.toString(defValue));
        if (val == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private URL getResource(ClassLoader loader, String resourceName) {
        if (loader == null) {
            return ClassLoader.getSystemResource(resourceName);
        }
        return loader.getResource(resourceName);
    }

    private void load(Properties props) {
        if (props == null) {
            return;
        }
        for (String name : props.stringPropertyNames()) {
            String val;
            if (!name.startsWith("org.eclipse.jetty.logging.") && !name.endsWith(SUFFIX_LEVEL) && !name.endsWith(SUFFIX_STACKS) || (val = props.getProperty(name)) == null) continue;
            this.properties.setProperty(name, val);
        }
    }

    private Properties readProperties(ClassLoader loader, String resourceName) {
        Properties properties;
        block9: {
            URL propsUrl = this.getResource(loader, resourceName);
            if (propsUrl == null) {
                return null;
            }
            InputStream in = propsUrl.openStream();
            try {
                Properties p = new Properties();
                p.load(in);
                properties = p;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[WARN] Error loading logging config: " + propsUrl);
                    e.printStackTrace();
                    return null;
                }
            }
            in.close();
        }
        return properties;
    }
}

