/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.core.utils.BufferedProcessInputStream;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.FrameworkUtil;

public final class RpmPackageBuildProposalsJob
extends Job {
    private static RpmPackageBuildProposalsJob job = null;
    private IJobChangeListener updateFinishedListener = new JobChangeAdapter();
    protected static final IPropertyChangeListener PROPERTY_LISTENER = event -> {
        if (event.getProperty().equals("currentRpmtools")) {
            RpmPackageBuildProposalsJob.update(true);
        }
    };
    protected static final IPreferenceStore STORE = new ScopedPreferenceStore(InstanceScope.INSTANCE, FrameworkUtil.getBundle(RpmPackageBuildProposalsJob.class).getSymbolicName());

    private RpmPackageBuildProposalsJob(String name) {
        super(name);
        this.addJobChangeListener(this.updateFinishedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        block29: {
            String rpmListCmd = STORE.getString("currentRpmtools");
            String rpmListFilepath = STORE.getString("rpmListFilePath");
            Path bkupFile = Paths.get(rpmListFilepath + ".bkup", new String[0]);
            try {
                monitor.beginTask(Messages.RpmPackageBuildProposalsJob_1, -1);
                if (!Files.exists(Paths.get("/bin/sh", new String[0]), new LinkOption[0])) break block29;
                BufferedProcessInputStream in = Utils.runCommandToInputStream((String[])new String[]{"/bin/sh", "-c", rpmListCmd});
                Path rpmListFile = Paths.get(rpmListFilepath, new String[0]);
                if (Files.exists(rpmListFile, new LinkOption[0])) {
                    Files.copy(Paths.get(rpmListFilepath, new String[0]), bkupFile, new CopyOption[0]);
                }
                try (BufferedWriter out = Files.newBufferedWriter(rpmListFile, new OpenOption[0]);
                     BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));){
                    String line;
                    monitor.subTask(Messages.RpmPackageBuildProposalsJob_2 + rpmListCmd + Messages.RpmPackageBuildProposalsJob_3);
                    while ((line = reader.readLine()) != null) {
                        monitor.subTask(line);
                        out.write(line + "\n");
                        if (!monitor.isCanceled()) continue;
                        in.destroyProcess();
                        in.close();
                        if (Files.exists(rpmListFile, new LinkOption[0]) && Files.exists(bkupFile, new LinkOption[0])) {
                            Files.copy(bkupFile, Paths.get(rpmListFilepath, new String[0]), new CopyOption[0]);
                            Files.delete(bkupFile);
                        }
                        Activator.packagesList = new RpmPackageProposalsList();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    in.close();
                    Files.deleteIfExists(bkupFile);
                    int processExitValue = 0;
                    try {
                        processExitValue = in.getExitValue();
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        reader.close();
                        if (out != null) {
                            out.close();
                        }
                        monitor.done();
                        return iStatus;
                    }
                    if (processExitValue != 0) {
                        SpecfileLog.log(2, processExitValue, NLS.bind((String)Messages.RpmPackageBuildProposalsJob_NonZeroReturn, (Object)processExitValue), null);
                    }
                }
            }
            catch (IOException e) {
                SpecfileLog.logError(e);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
        Activator.packagesList = new RpmPackageProposalsList();
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        return ((Object)((Object)this)).equals((Object)job);
    }

    public static void update(boolean async) {
        boolean runJob = false;
        Date today = new Date();
        if (STORE.getBoolean("rpmListBackgroundBuild")) {
            int period = STORE.getInt("rpmListBuildPeriod");
            if (period == 1) {
                runJob = true;
            } else {
                long lastBuildTime = STORE.getLong("rpmLisMastBuild");
                if (lastBuildTime == 0L) {
                    runJob = true;
                } else {
                    long interval = (today.getTime() - lastBuildTime) / 86400000L;
                    if (period == 2 && interval >= 7L) {
                        runJob = true;
                    } else if (period == 3 && interval >= 30L) {
                        runJob = true;
                    }
                }
            }
            if (runJob) {
                if (job == null) {
                    job = new RpmPackageBuildProposalsJob(Messages.RpmPackageBuildProposalsJob_0);
                } else {
                    job.cancel();
                }
                if (async) {
                    job.schedule();
                } else {
                    job.run((IProgressMonitor)new NullProgressMonitor());
                }
                STORE.setValue("rpmLisMastBuild", today.getTime());
            }
        } else if (job != null) {
            job.cancel();
            job = null;
        }
    }

    public static Set<String> getPackages() throws InterruptedException, IOException {
        if (job.getThread() != Thread.currentThread()) {
            job.join();
        }
        HashSet<String> list = new HashSet<String>();
        String rpmpkgsFile = Activator.getDefault().getPreferenceStore().getString("rpmListFilePath");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(rpmpkgsFile)));){
            String line = reader.readLine();
            while (line != null) {
                list.add(line.trim());
                line = reader.readLine();
            }
        }
        return list;
    }

    public static void setPropertyChangeListener(boolean activated) {
        if (activated) {
            STORE.addPropertyChangeListener(PROPERTY_LISTENER);
        } else {
            STORE.removePropertyChangeListener(PROPERTY_LISTENER);
        }
    }
}

