/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalOwnerShapeEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editpolicies.LEDEditPolicy;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editpolicies.PortsColorEditPolicy;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.BottomTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.LEDFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.LogicColorConstants;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.TerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.TopTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.StringConstants;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PropertiesSetStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class LEDEditPart
extends TerminalOwnerShapeEditPart {
    private final Dimension ledSizeDP = new Dimension(61, 44);

    public LEDEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new LEDEditPolicy());
        this.installEditPolicy("portsColorEditPolicy", (EditPolicy)new PortsColorEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshValue();
        this.refreshFontColor();
    }

    protected void refreshValue() {
        LED LEDStyle = (LED)ViewUtil.resolveSemanticElement((View)((View)this.getModel()));
        if (LEDStyle != null) {
            ((LEDFigure)this.getMainFigure()).setValue(LEDStyle.getValue());
        }
    }

    protected void refreshBounds() {
        Dimension size = this.getFigure().getSize();
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    protected void setFontColor(Color color) {
        ((LEDFigure)this.getMainFigure()).setFontColor(color);
    }

    protected void handleNotificationEvent(Notification evt) {
        if (SemanticPackage.eINSTANCE.getLED_Value().equals(evt.getFeature())) {
            this.refreshValue();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(evt.getFeature())) {
            this.refreshFontColor();
        } else if (NotationPackage.eINSTANCE.getPropertyValue_RawValue().equals(evt.getFeature())) {
            PropertiesSetStyle style;
            View viewContainer = ViewUtil.getViewContainer((EObject)((EObject)evt.getNotifier()));
            if (viewContainer != null && viewContainer.equals(this.getNotationView()) && (style = (PropertiesSetStyle)this.getNotationView().getNamedStyle(NotationPackage.eINSTANCE.getPropertiesSetStyle(), StringConstants.PORTS_PROPERTIES_STYLE_NAME)) != null && style.getPropertiesMap().get((Object)StringConstants.PORTS_COLOR_PROPERTY_NAME).equals(evt.getNotifier())) {
                for (Object obj : this.getChildren()) {
                    if (obj instanceof TerminalEditPart) {
                        ((TerminalEditPart)((Object)obj)).refreshBackgroundColor();
                    }
                    this.getFigure().repaint();
                }
            }
        } else {
            super.handleNotificationEvent(evt);
        }
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new NonResizableEditPolicyEx();
    }

    protected NodeFigure createMainFigure() {
        Dimension ledSizeLP = new Dimension(this.ledSizeDP);
        this.getMapMode().DPtoLP((Translatable)ledSizeLP);
        return new LEDFigure(ledSizeLP);
    }

    public Map createBoundsMap() {
        HashMap<String, Point> boundMap = new HashMap<String, Point>();
        IMapMode mm = this.getMapMode();
        boundMap.put("A", new Point(mm.DPtoLP(51), mm.DPtoLP(1)));
        boundMap.put("B", new Point(mm.DPtoLP(36), mm.DPtoLP(1)));
        boundMap.put("C", new Point(mm.DPtoLP(21), mm.DPtoLP(1)));
        boundMap.put("D", new Point(mm.DPtoLP(6), mm.DPtoLP(1)));
        boundMap.put("1", new Point(mm.DPtoLP(51), mm.DPtoLP(44)));
        boundMap.put("2", new Point(mm.DPtoLP(36), mm.DPtoLP(44)));
        boundMap.put("3", new Point(mm.DPtoLP(21), mm.DPtoLP(44)));
        boundMap.put("4", new Point(mm.DPtoLP(6), mm.DPtoLP(44)));
        return boundMap;
    }

    public NodeFigure createOwnedTerminalFigure(TerminalEditPart terminalEP) {
        Terminal terminal = (Terminal)ViewUtil.resolveSemanticElement((View)((View)terminalEP.getModel()));
        if (terminal == null) {
            return null;
        }
        TerminalFigure theFigure = null;
        int side = 1;
        if (terminal instanceof InputTerminal) {
            theFigure = new TopTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(6), this.getMapMode().DPtoLP(7)));
        } else {
            theFigure = new BottomTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(6), this.getMapMode().DPtoLP(7)));
            side = 4;
        }
        Dimension ledSizeLP = new Dimension(this.ledSizeDP);
        this.getMapMode().DPtoLP((Translatable)ledSizeLP);
        terminalEP.setLocator(new TerminalFigure.TerminalLocator(this.getFigure(), ledSizeLP, side));
        return theFigure;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
            return FigureUtilities.colorToInteger((Color)LogicColorConstants.displayText);
        }
        return super.getPreferredValue(feature);
    }
}

