/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.handles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class CompartmentCollapseTracker
extends AbstractTool
implements DragTracker {
    private final GraphicalEditPart myHost;

    public CompartmentCollapseTracker(GraphicalEditPart editPart) {
        this.myHost = editPart;
    }

    protected List<?> createOperationSet() {
        ArrayList<GraphicalEditPart> list = new ArrayList<GraphicalEditPart>(1);
        list.add(this.myHost);
        return list;
    }

    protected boolean handleButtonDown(int button) {
        DrawerStyle style;
        View view = (View)this.myHost.getModel();
        if (view != null && (style = (DrawerStyle)view.getStyle(NotationPackage.eINSTANCE.getDrawerStyle())) != null) {
            Boolean newValue = style.isCollapsed() ? Boolean.FALSE : Boolean.TRUE;
            this.setCurrentCommand(this.createCommand(style, newValue));
            this.executeCurrentCommand();
            return true;
        }
        return false;
    }

    private Command createCommand(DrawerStyle style, Boolean newValue) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)style);
        return new WrappingCommand(editingDomain, SetCommand.create((EditingDomain)editingDomain, (Object)style, (Object)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed(), (Object)newValue));
    }

    protected String getCommandName() {
        return "Collapse Compartment";
    }

    protected String getDebugName() {
        return "Collapse Compartment Tool";
    }
}

