/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.labels;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gmf.runtime.lite.commands.ChangeLocationCommand;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.lite.edit.parts.update.IExternallyUpdatableEditPart;
import org.eclipse.gmf.runtime.lite.edit.parts.update.UpdaterUtil;
import org.eclipse.gmf.runtime.lite.figures.ExternalChildPositionTracker;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;

public abstract class BaseExternalLabelEditPart
extends AbstractGraphicalEditPart {
    protected IExternallyUpdatableEditPart.ExternalRefresher boundsRefresher = new IExternallyUpdatableEditPart.ExternalRefresher(){

        @Override
        public void refresh() {
            if (!BaseExternalLabelEditPart.this.isActive()) {
                return;
            }
            BaseExternalLabelEditPart.this.refreshBounds();
        }

        @Override
        public boolean isAffectingEvent(Notification msg) {
            if (NotationPackage.eINSTANCE.getLocation().getEStructuralFeatures().contains(msg.getFeature())) {
                return true;
            }
            if (NotationPackage.eINSTANCE.getNode_LayoutConstraint() == msg.getFeature()) {
                return UpdaterUtil.affects(msg, NotationPackage.eINSTANCE.getLocation());
            }
            return false;
        }
    };
    private ExternalChildPositionTracker myPositionTracker;

    public BaseExternalLabelEditPart(View view) {
        this.setModel(view);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ResizableEditPolicy(){

            public EditPart getTargetEditPart(Request request) {
                if ("selection".equals(request.getType())) {
                    return this.getHost().getParent();
                }
                return super.getTargetEditPart(request);
            }

            protected org.eclipse.gef.commands.Command getMoveCommand(ChangeBoundsRequest request) {
                Node node = (Node)BaseExternalLabelEditPart.this.getModel();
                ChangeLocationCommand emfCommand = new ChangeLocationCommand(node, request, BaseExternalLabelEditPart.this.getFigure());
                return new WrappingCommand(TransactionUtil.getEditingDomain((EObject)node.getDiagram().getElement()), (Command)emfCommand);
            }
        });
    }

    public List<Handle> createSelectionHandles() {
        ArrayList<Handle> result = new ArrayList<Handle>();
        NonResizableHandleKit.addHandles((GraphicalEditPart)this, result, (DragTracker)this.getLabelDragTracker(), (Cursor)this.getHandleCursor());
        return result;
    }

    protected Cursor getHandleCursor() {
        return SharedCursors.HAND;
    }

    protected DragTracker getLabelDragTracker() {
        return new DragEditPartsTracker((EditPart)this){

            protected boolean isMove() {
                return true;
            }

            protected boolean handleButtonUp(int button) {
                boolean result = super.handleButtonUp(button);
                BaseExternalLabelEditPart.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)BaseExternalLabelEditPart.this.getParent()));
                return result;
            }
        };
    }

    public Object getAdapter(Class key) {
        if (ExternalChildPositionTracker.class == key) {
            return this.getPositionTracker();
        }
        return super.getAdapter(key);
    }

    public DragTracker getDragTracker(Request request) {
        return this.getLabelDragTracker();
    }

    public ExternalChildPositionTracker getPositionTracker() {
        if (this.myPositionTracker == null) {
            this.myPositionTracker = new ExternalChildPositionTracker((GraphicalEditPart)this);
        }
        return this.myPositionTracker;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBounds();
    }

    protected abstract void refreshBounds();
}

