/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.providers;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.map.editor.part.GMFMapVisualIDRegistry;
import org.eclipse.gmf.map.editor.providers.GMFMapElementTypes;
import org.eclipse.gmf.map.editor.providers.GMFMapStructuralFeatureParser;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.DesignLabelMapping;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.parser.GetParserOperation;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserProvider;
import org.eclipse.gmf.runtime.notation.View;

public class GMFMapParserProvider
extends AbstractProvider
implements IParserProvider {
    private IParser canvasMappingInfoParser;
    private IParser nodeMappingInfoParser;
    private IParser referenceInfoParser;
    private IParser compartmentMappingInfoParser;
    private IParser linkMappingInfoParser;
    private IParser labelMappingInfoParser;

    private IParser getCanvasMappingInfoParser() {
        if (this.canvasMappingInfoParser == null) {
            this.canvasMappingInfoParser = this.createCanvasMappingInfoParser();
        }
        return this.canvasMappingInfoParser;
    }

    protected IParser createCanvasMappingInfoParser() {
        GMFMapStructuralFeatureParser parser = new GMFMapStructuralFeatureParser((EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name()){

            @Override
            protected EObject getDomainElement(EObject element) {
                return element instanceof CanvasMapping ? ((CanvasMapping)element).getDomainMetaElement() : null;
            }

            @Override
            protected boolean isAffectingFeature(Object eventFeature) {
                return eventFeature == GMFMapPackage.eINSTANCE.getCanvasMapping_DomainMetaElement();
            }
        };
        return parser;
    }

    private IParser getNodeMappingInfoParser() {
        if (this.nodeMappingInfoParser == null) {
            this.nodeMappingInfoParser = this.createNodeMappingInfoParser();
        }
        return this.nodeMappingInfoParser;
    }

    protected IParser createNodeMappingInfoParser() {
        GMFMapStructuralFeatureParser parser = new GMFMapStructuralFeatureParser((EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name()){

            @Override
            protected EObject getDomainElement(EObject element) {
                return element instanceof NodeMapping ? ((NodeMapping)element).getDomainMetaElement() : null;
            }

            @Override
            protected boolean isAffectingFeature(Object eventFeature) {
                return eventFeature == GMFMapPackage.eINSTANCE.getMappingEntry_DomainMetaElement();
            }
        };
        return parser;
    }

    private IParser getReferenceInfoParser() {
        if (this.referenceInfoParser == null) {
            this.referenceInfoParser = this.createReferenceInfoParser();
        }
        return this.referenceInfoParser;
    }

    protected IParser createReferenceInfoParser() {
        GMFMapStructuralFeatureParser parser = new GMFMapStructuralFeatureParser(null){

            @Override
            public String getPrintString(IAdaptable adapter, int flags) {
                StringBuffer sb = new StringBuffer();
                EObject element = (EObject)adapter.getAdapter(EObject.class);
                if (element instanceof NodeReference) {
                    NodeReference ref = (NodeReference)element;
                    if (ref.getContainmentFeature() != null) {
                        sb.append(ref.getContainmentFeature().getEContainingClass().getName());
                        sb.append(':');
                        sb.append(this.getStringByPattern((EObject)ref.getContainmentFeature(), (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), DEFAULT_PROCESSOR));
                    }
                    if (ref.getChildrenFeature() != null) {
                        sb.append(' ');
                        sb.append('(');
                        sb.append(ref.getChildrenFeature().getEContainingClass().getName());
                        sb.append(':');
                        sb.append(this.getStringByPattern((EObject)ref.getChildrenFeature(), (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), DEFAULT_PROCESSOR));
                        sb.append(')');
                    }
                }
                return sb.toString();
            }

            @Override
            protected boolean isAffectingFeature(Object eventFeature) {
                return eventFeature == GMFMapPackage.eINSTANCE.getNeedsContainment_ContainmentFeature() || eventFeature == GMFMapPackage.eINSTANCE.getNodeReference_ChildrenFeature();
            }

            @Override
            public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
                return UnexecutableCommand.INSTANCE;
            }
        };
        return parser;
    }

    private IParser getCompartmentMappingInfoParser() {
        if (this.compartmentMappingInfoParser == null) {
            this.compartmentMappingInfoParser = this.createCompartmentMappingInfoParser();
        }
        return this.compartmentMappingInfoParser;
    }

    protected IParser createCompartmentMappingInfoParser() {
        GMFMapStructuralFeatureParser parser = new GMFMapStructuralFeatureParser((EStructuralFeature)GMFGraphPackage.eINSTANCE.getIdentity_Name()){

            @Override
            protected EObject getDomainElement(EObject element) {
                return element instanceof CompartmentMapping ? ((CompartmentMapping)element).getCompartment() : null;
            }

            @Override
            protected boolean isAffectingFeature(Object eventFeature) {
                return eventFeature == GMFMapPackage.eINSTANCE.getCompartmentMapping_Compartment();
            }
        };
        return parser;
    }

    private IParser getLinkMappingInfoParser() {
        if (this.linkMappingInfoParser == null) {
            this.linkMappingInfoParser = this.createLinkMappingInfoParser();
        }
        return this.linkMappingInfoParser;
    }

    protected IParser createLinkMappingInfoParser() {
        GMFMapStructuralFeatureParser parser = new GMFMapStructuralFeatureParser((EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name()){

            @Override
            protected EObject getDomainElement(EObject element) {
                return element instanceof LinkMapping ? ((LinkMapping)element).getDomainMetaElement() : null;
            }

            @Override
            public String getPrintString(IAdaptable adapter, int flags) {
                StringBuffer sb = new StringBuffer();
                EObject element = (EObject)adapter.getAdapter(EObject.class);
                if (element instanceof LinkMapping) {
                    LinkMapping mapping = (LinkMapping)element;
                    sb.append(super.getPrintString(adapter, flags));
                    sb.append('(');
                    if (mapping.getSourceMetaFeature() != null) {
                        sb.append(mapping.getSourceMetaFeature().getEContainingClass().getName());
                        sb.append(':');
                        sb.append(this.getStringByPattern((EObject)mapping.getSourceMetaFeature(), (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), DEFAULT_PROCESSOR));
                    }
                    sb.append('-');
                    sb.append('>');
                    if (mapping.getLinkMetaFeature() != null) {
                        sb.append(mapping.getLinkMetaFeature().getEContainingClass().getName());
                        sb.append(':');
                        sb.append(this.getStringByPattern((EObject)mapping.getLinkMetaFeature(), (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), DEFAULT_PROCESSOR));
                    }
                    sb.append(')');
                }
                return sb.toString();
            }

            @Override
            protected boolean isAffectingFeature(Object eventFeature) {
                return eventFeature == GMFMapPackage.eINSTANCE.getMappingEntry_DomainMetaElement() || eventFeature == GMFMapPackage.eINSTANCE.getLinkMapping_SourceMetaFeature() || eventFeature == GMFMapPackage.eINSTANCE.getLinkMapping_LinkMetaFeature();
            }

            @Override
            public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
                return UnexecutableCommand.INSTANCE;
            }
        };
        return parser;
    }

    private IParser getLabelMappingInfoParser() {
        if (this.labelMappingInfoParser == null) {
            this.labelMappingInfoParser = this.createLabelMappingInfoParser();
        }
        return this.labelMappingInfoParser;
    }

    protected IParser createLabelMappingInfoParser() {
        GMFMapStructuralFeatureParser parser = new GMFMapStructuralFeatureParser(null){

            @Override
            public String getPrintString(IAdaptable adapter, int flags) {
                StringBuffer sb = new StringBuffer();
                EObject element = (EObject)adapter.getAdapter(EObject.class);
                if (element instanceof FeatureLabelMapping) {
                    FeatureLabelMapping mapping = (FeatureLabelMapping)element;
                    Iterator it = mapping.getFeatures().iterator();
                    while (it.hasNext()) {
                        EStructuralFeature feature = (EStructuralFeature)it.next();
                        sb.append(feature.getEContainingClass().getName());
                        sb.append(':');
                        sb.append(this.getStringByPattern((EObject)feature, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), DEFAULT_PROCESSOR));
                        if (!it.hasNext()) continue;
                        sb.append(',');
                        sb.append(' ');
                    }
                } else if (element instanceof DesignLabelMapping) {
                    sb.append("<design>");
                } else if (element instanceof LabelMapping) {
                    sb.append("<custom>");
                }
                return sb.toString();
            }

            @Override
            protected boolean isAffectingFeature(Object eventFeature) {
                return eventFeature == GMFMapPackage.eINSTANCE.getFeatureLabelMapping_Features();
            }

            @Override
            public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
                return UnexecutableCommand.INSTANCE;
            }
        };
        return parser;
    }

    protected IParser getParser(int visualID) {
        switch (visualID) {
            case 5001: {
                return this.getCanvasMappingInfoParser();
            }
            case 5003: {
                return this.getNodeMappingInfoParser();
            }
            case 5005: 
            case 5006: {
                return this.getReferenceInfoParser();
            }
            case 5004: {
                return this.getCompartmentMappingInfoParser();
            }
            case 5002: {
                return this.getLinkMappingInfoParser();
            }
            case 3002: 
            case 3003: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: {
                return this.getLabelMappingInfoParser();
            }
        }
        return null;
    }

    public IParser getParser(IAdaptable hint) {
        String vid = (String)hint.getAdapter(String.class);
        if (vid != null) {
            return this.getParser(GMFMapVisualIDRegistry.getVisualID(vid));
        }
        View view = (View)hint.getAdapter(View.class);
        if (view != null) {
            return this.getParser(GMFMapVisualIDRegistry.getVisualID(view));
        }
        return null;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof GetParserOperation) {
            IAdaptable hint = ((GetParserOperation)operation).getHint();
            if (GMFMapElementTypes.getElement(hint) == null) {
                return false;
            }
            return this.getParser(hint) != null;
        }
        return false;
    }
}

