/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.FBRuleReasoner;
import org.apache.jena.reasoner.rulesys.LPBackwardRuleInfGraph;
import org.apache.jena.reasoner.rulesys.RETERuleInfGraph;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RulePreprocessHook;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.impl.LPRuleStore;
import org.apache.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class GenericRuleReasoner
extends FBRuleReasoner {
    protected LPRuleStore bRuleStore;
    protected RuleMode mode = HYBRID;
    protected static final boolean cachePreload = true;
    protected boolean enableTGCCaching = false;
    protected boolean enableOWLTranslation = false;
    protected HashSet<RulePreprocessHook> preprocessorHooks;
    public boolean filterFunctors = true;
    private static final OWLRuleTranslationHook owlTranslator = new OWLRuleTranslationHook();
    public static final RuleMode FORWARD = new RuleMode("forward");
    public static final RuleMode FORWARD_RETE = new RuleMode("forwardRETE");
    public static final RuleMode BACKWARD = new RuleMode("backward");
    public static final RuleMode HYBRID = new RuleMode("hybrid");

    public GenericRuleReasoner(List<Rule> rules) {
        super(rules);
    }

    public GenericRuleReasoner(ReasonerFactory factory, Resource configuration) {
        super(factory);
        this.configuration = configuration;
        if (configuration != null) {
            this.loadConfiguration(configuration);
        }
    }

    public GenericRuleReasoner(List<Rule> rules, ReasonerFactory factory) {
        super(rules, factory);
    }

    protected GenericRuleReasoner(List<Rule> rules, Graph schemaGraph, ReasonerFactory factory, RuleMode mode) {
        this(rules, factory);
        this.schemaGraph = schemaGraph;
        this.mode = mode;
    }

    public void setMode(RuleMode mode) {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can't change mode of a reasoner bound to a schema");
        }
        this.mode = mode;
        this.preload = null;
        this.bRuleStore = null;
    }

    @Override
    public void setRules(List<Rule> rules) {
        super.setRules(rules);
    }

    public void setOWLTranslation(boolean enableOWLTranslation) {
        if (enableOWLTranslation && this.mode != HYBRID) {
            throw new ReasonerException("Can only enable OWL rule translation in HYBRID mode");
        }
        this.enableOWLTranslation = enableOWLTranslation;
        if (enableOWLTranslation) {
            this.addPreprocessingHook(owlTranslator);
        } else {
            this.removePreprocessingHook(owlTranslator);
        }
    }

    public void setTransitiveClosureCaching(boolean enableTGCCaching) {
        this.enableTGCCaching = enableTGCCaching;
    }

    public void setFunctorFiltering(boolean param) {
        this.filterFunctors = param;
    }

    public void addPreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new HashSet();
        }
        this.preprocessorHooks.add(hook);
    }

    public void removePreprocessingHook(RulePreprocessHook hook) {
        if (this.preprocessorHooks != null) {
            this.preprocessorHooks.remove(hook);
        }
    }

    @Override
    protected boolean doSetResourceParameter(Property parameter, Resource value) {
        if (this.isRuleSetURL(parameter)) {
            this.addRules(Rule.rulesFromURL(value.getURI()));
        } else if (this.isRuleSet(parameter)) {
            this.addRulesFromURLs(value);
            this.addRulesFromStrings(value);
        } else {
            return false;
        }
        return true;
    }

    private void addRulesFromStrings(Resource value) {
        Iterator<Statement> it = this.getHasRuleStatements(value);
        while (it.hasNext()) {
            this.addRuleFromString(it.next().getString());
        }
    }

    private void addRuleFromString(String ruleString) {
        this.addRules(Rule.parseRules(ruleString));
    }

    private void addRulesFromURLs(Resource value) {
        Iterator<Statement> that = this.getRuleSetURLStatements(value);
        while (that.hasNext()) {
            this.addRules(Rule.rulesFromURL(that.next().getResource().getURI()));
        }
    }

    private Iterator<Statement> getHasRuleStatements(Resource value) {
        return value.listProperties(ReasonerVocabulary.hasRule);
    }

    private Iterator<Statement> getRuleSetURLStatements(Resource value) {
        return value.listProperties(ReasonerVocabulary.ruleSetURL);
    }

    private boolean isHasRule(Property parameter) {
        return parameter.equals(ReasonerVocabulary.hasRule);
    }

    private boolean isRuleSet(Property parameter) {
        return parameter.equals(ReasonerVocabulary.ruleSet);
    }

    private boolean isRuleSetURL(Property parameter) {
        return parameter.equals(ReasonerVocabulary.ruleSetURL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doSetParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPenableFunctorFiltering)) {
            this.filterFunctors = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        } else if (this.isHasRule(parameter)) {
            this.addRuleFromString(value.toString());
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPenableOWLTranslation)) {
            this.enableOWLTranslation = Util.convertBooleanPredicateArg(parameter, value);
            if (this.enableOWLTranslation) {
                this.addPreprocessingHook(owlTranslator);
                return true;
            } else {
                this.removePreprocessingHook(owlTranslator);
            }
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPenableTGCCaching)) {
            this.enableTGCCaching = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        } else if (parameter.equals(ReasonerVocabulary.PROPruleMode)) {
            if (value.equals(GenericRuleReasoner.FORWARD.name)) {
                this.mode = FORWARD;
                return true;
            } else if (value.equals(GenericRuleReasoner.FORWARD_RETE.name)) {
                this.mode = FORWARD_RETE;
                return true;
            } else if (value.equals(GenericRuleReasoner.BACKWARD.name)) {
                this.mode = BACKWARD;
                return true;
            } else {
                if (!value.equals(GenericRuleReasoner.HYBRID.name)) throw new IllegalParameterException("PROPruleMode can only be 'forward'm 'forwardRETE', 'backward', 'hybrid', not " + value);
                this.mode = HYBRID;
            }
            return true;
        } else {
            if (!parameter.equals(ReasonerVocabulary.PROPruleSet)) return super.doSetParameter(parameter, value);
            if (!(value instanceof String)) throw new IllegalParameterException("PROPruleSet value should be a URI string. Was a " + value.getClass());
            this.addRules(GenericRuleReasoner.loadRules((String)value));
        }
        return true;
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to a GenericRuleReasoner");
        }
        Graph graph = null;
        if (this.mode == FORWARD) {
            graph = new BasicForwardRuleInfGraph(this, this.rules, null, tbox);
            ((InfGraph)graph).prepare();
        } else if (this.mode == FORWARD_RETE) {
            graph = new RETERuleInfGraph(this, this.rules, null, tbox);
            ((InfGraph)graph).prepare();
        } else if (this.mode == BACKWARD) {
            graph = tbox;
        } else {
            List ruleSet = this.rules;
            graph = new FBRuleInfGraph(this, ruleSet, this.getPreload(), tbox);
            if (this.enableTGCCaching) {
                ((FBRuleInfGraph)graph).setUseTGCCache();
            }
            ((FBRuleInfGraph)graph).prepare();
        }
        GenericRuleReasoner grr = new GenericRuleReasoner(this.rules, graph, this.factory, this.mode);
        grr.setDerivationLogging(this.recordDerivations);
        grr.setTraceOn(this.traceOn);
        grr.setTransitiveClosureCaching(this.enableTGCCaching);
        grr.setFunctorFiltering(this.filterFunctors);
        if (this.preprocessorHooks != null) {
            for (RulePreprocessHook preprocessorHook : this.preprocessorHooks) {
                grr.addPreprocessingHook(preprocessorHook);
            }
        }
        return grr;
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        Graph schemaArg = this.schemaGraph == null ? this.getPreload() : this.schemaGraph;
        BaseInfGraph graph = null;
        if (this.mode == FORWARD) {
            graph = new BasicForwardRuleInfGraph(this, this.rules, schemaArg);
            ((BasicForwardRuleInfGraph)graph).setTraceOn(this.traceOn);
        } else if (this.mode == FORWARD_RETE) {
            graph = new RETERuleInfGraph(this, this.rules, schemaArg);
            ((BasicForwardRuleInfGraph)graph).setTraceOn(this.traceOn);
            ((BasicForwardRuleInfGraph)graph).setFunctorFiltering(this.filterFunctors);
        } else if (this.mode == BACKWARD) {
            graph = new LPBackwardRuleInfGraph(this, this.getBruleStore(), data, schemaArg);
            ((LPBackwardRuleInfGraph)graph).setTraceOn(this.traceOn);
        } else {
            List<Rule> ruleSet = ((FBRuleInfGraph)schemaArg).getRules();
            FBRuleInfGraph fbgraph = new FBRuleInfGraph(this, ruleSet, schemaArg);
            graph = fbgraph;
            if (this.enableTGCCaching) {
                fbgraph.setUseTGCCache();
            }
            fbgraph.setTraceOn(this.traceOn);
            fbgraph.setFunctorFiltering(this.filterFunctors);
            if (this.preprocessorHooks != null) {
                for (RulePreprocessHook preprocessorHook : this.preprocessorHooks) {
                    fbgraph.addPreprocessingHook(preprocessorHook);
                }
            }
        }
        graph.setDerivationLogging(this.recordDerivations);
        graph.rebind(data);
        return graph;
    }

    @Override
    protected synchronized InfGraph getPreload() {
        if (this.preload == null && this.mode == HYBRID) {
            this.preload = new FBRuleInfGraph(this, this.rules, null, GraphMemFactory.createDefaultGraph());
            if (this.enableTGCCaching) {
                ((FBRuleInfGraph)this.preload).setUseTGCCache();
            }
            this.preload.prepare();
        }
        return this.preload;
    }

    protected LPRuleStore getBruleStore() {
        if (this.bRuleStore == null) {
            this.bRuleStore = new LPRuleStore(this.rules);
        }
        return this.bRuleStore;
    }

    public static class RuleMode {
        String name;

        protected RuleMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

