/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput0.states;

import java.util.Map;
import java.util.TreeMap;
import org.apache.jena.rdfxml.xmlinput0.impl.AbsXMLContext;
import org.apache.jena.rdfxml.xmlinput0.impl.XMLHandler;
import org.apache.jena.rdfxml.xmlinput0.states.Frame;
import org.apache.jena.rdfxml.xmlinput0.states.FrameI;
import org.apache.jena.rdfxml.xmlinput0.states.InnerXMLLiteral;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public abstract class AbsXMLLiteral
extends Frame {
    boolean checkComposingChar = true;
    static Map<String, String> xmlNameSpace = new TreeMap<String, String>();
    protected final StringBuffer rslt;
    public final Map<String, String> namespaces;

    @Override
    String suggestParsetypeLiteral() {
        return "";
    }

    private static String prefix(String qname) {
        int colon = qname.indexOf(58);
        return colon == -1 ? "" : qname.substring(0, colon);
    }

    protected void append(String s) {
        this.rslt.append(s);
    }

    private void append(char[] ch, int s, int l) {
        this.rslt.append(ch, s, l);
    }

    protected void append(char s) {
        this.rslt.append(s);
    }

    public AbsXMLLiteral(FrameI p, AbsXMLContext x, StringBuffer r) {
        super(p, x);
        this.rslt = r;
        this.namespaces = xmlNameSpace;
    }

    public AbsXMLLiteral(AbsXMLLiteral p, Map<String, String> ns) {
        super((FrameI)p, p.xml);
        this.rslt = p.rslt;
        this.namespaces = ns;
    }

    public AbsXMLLiteral(XMLHandler h, AbsXMLContext x) {
        super(h, x);
        this.rslt = new StringBuffer();
        this.namespaces = xmlNameSpace;
    }

    private void useNameSpace(String prefix, String uri, Map<String, String> ns) {
        if (!uri.equals(this.namespaces.get(prefix))) {
            ns.put(prefix, uri);
        }
    }

    @Override
    public abstract void endElement() throws SAXParseException;

    void startLitElement(String uri, String rawName, Map<String, String> ns) {
        this.append('<');
        this.append(rawName);
        this.useNameSpace(AbsXMLLiteral.prefix(rawName), uri, ns);
    }

    private void appendAttrValue(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String replace = switch (ch) {
                case '&' -> "&amp;";
                case '<' -> "&lt;";
                case '\"' -> "&quot;";
                case '\t' -> "&#x9;";
                case '\n' -> "&#xA;";
                case '\r' -> "&#xD;";
                default -> null;
            };
            if (replace != null) {
                this.append(replace);
                continue;
            }
            this.append(ch);
        }
    }

    @Override
    public void characters(char[] chrs, int start, int length) throws SAXParseException {
        if (this.checkComposingChar) {
            this.checkComposingChar(this.taint, chrs, start, length);
        }
        this.checkComposingChar = false;
        for (int i = 0; i < length; ++i) {
            char ch = chrs[start + i];
            String replace = switch (ch) {
                case '&' -> "&amp;";
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '\r' -> "&#xD;";
                default -> null;
            };
            if (replace != null) {
                this.append(replace);
                continue;
            }
            this.append(ch);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXParseException {
        this.append("<!--");
        this.append(ch, start, length);
        this.append("-->");
        this.checkComposingChar = true;
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.append("<?");
        this.append(target);
        this.append(' ');
        this.append(data);
        this.append("?>");
        this.checkComposingChar = true;
    }

    @Override
    public FrameI startElement(String uri, String localName, String rawName, Attributes atts) {
        String prefix;
        this.checkComposingChar = true;
        TreeMap<String, String> attrMap = new TreeMap<String, String>();
        Map<String, String> childNameSpaces = new TreeMap<String, String>();
        this.startLitElement(uri, rawName, childNameSpaces);
        for (int i = atts.getLength() - 1; i >= 0; --i) {
            String string = atts.getURI(i);
            String qname = atts.getQName(i);
            String prefix2 = AbsXMLLiteral.prefix(qname);
            if (!prefix2.equals("")) {
                this.useNameSpace(prefix2, string, childNameSpaces);
            }
            attrMap.put(qname, atts.getValue(i));
        }
        for (Map.Entry entry : childNameSpaces.entrySet()) {
            this.append(" xmlns");
            prefix = (String)entry.getKey();
            if (!"".equals(prefix)) {
                this.append(':');
                this.append(prefix);
            }
            this.append("=\"");
            this.appendAttrValue((String)entry.getValue());
            this.append('\"');
        }
        for (Map.Entry entry : attrMap.entrySet()) {
            this.append(' ');
            this.append((String)entry.getKey());
            this.append("=\"");
            this.appendAttrValue((String)entry.getValue());
            this.append('\"');
        }
        this.append('>');
        if (childNameSpaces.isEmpty()) {
            childNameSpaces = this.namespaces;
        } else {
            for (Map.Entry<Object, Object> entry : this.namespaces.entrySet()) {
                prefix = (String)entry.getKey();
                if (childNameSpaces.containsKey(prefix)) continue;
                childNameSpaces.put(prefix, (String)entry.getValue());
            }
        }
        return new InnerXMLLiteral(this, rawName, childNameSpaces);
    }

    static {
        xmlNameSpace.put("xml", xmlns);
        xmlNameSpace.put("", "");
    }
}

