/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.property.ValidatedProperty;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ValidatedPropertyBase<O>
implements ValidatedProperty<O> {
    static Comparator<Status> STATUS_SORTER = (s1, s2) -> s1.getState().compareTo(s2.getState());
    static Predicate<Status> WARNING_ERROR = s -> s.getState() == Status.State.ERROR || s.getState() == Status.State.WARNING;
    private final ReadOnlyObjectWrapper<Status> status = new ReadOnlyObjectWrapper((Object)this, "status", (Object)Status.ok());
    private boolean onRequestOnly = false;
    private Map<String, Supplier<?>> dependencyMap = new HashMap();
    private final List<BiFunction<O, Map<String, Object>, Status>> validationList = new ArrayList<BiFunction<O, Map<String, Object>, Status>>();
    private List<Subscription> listeners = new ArrayList<Subscription>();
    private ObservableList<Status> validationStatusList = FXCollections.observableArrayList();
    protected final Property<O> domainProperty;
    private boolean batchValidation = true;
    private Executor batchExecutor;
    private final AtomicBoolean validationScheduled = new AtomicBoolean();
    private static @Nullable ThreadSynchronize DEFAULT_THREAD_SYNC;

    public ValidatedPropertyBase(Property<O> domainProperty) {
        this.domainProperty = domainProperty;
        this.domainProperty.addListener(this::handlePropertyChange);
    }

    private Executor getOrCreatedExecutor() {
        ThreadSynchronize sync;
        Optional<ThreadSynchronize> threadSync;
        if (this.batchExecutor != null) {
            return this.batchExecutor;
        }
        if (DEFAULT_THREAD_SYNC == null && (threadSync = ServiceUtils.getService(ThreadSynchronize.class)).isPresent()) {
            DEFAULT_THREAD_SYNC = threadSync.get();
        }
        return (sync = DEFAULT_THREAD_SYNC) == null ? r -> r.run() : sync::asyncExec;
    }

    public void setBatchValidation(boolean batchValidation) {
        this.batchValidation = batchValidation;
    }

    public boolean isBatchValidation() {
        return this.batchValidation;
    }

    public void setBatchExecutor(@Nullable Executor batchExecutor) {
        this.batchExecutor = batchExecutor;
    }

    public Executor getBatchExecutor() {
        return this.batchExecutor;
    }

    @Override
    public ReadOnlyObjectProperty<Status> statusProperty() {
        return this.status.getReadOnlyProperty();
    }

    @Override
    public Subscription registerValidator(Function<O, Status> validator) {
        return this.registerValidator((O t, Map<String, Object> dep) -> (Status)validator.apply(t));
    }

    @Override
    public Subscription registerValidator(BiFunction<O, Map<String, Object>, Status> validator) {
        this.validationList.add(validator);
        return () -> {
            this.validationList.remove(validator);
            this._runValidation();
        };
    }

    @Override
    public Subscription registerDependency(ValidatedPropertyBase<?> property) {
        return this.dependency(property.domainProperty.getName(), property);
    }

    @Override
    public Subscription registerDependency(Property<?> property) {
        return this.dependency(property.getName(), property);
    }

    @Override
    public Subscription dependency(String name, ValidatedPropertyBase<?> property) {
        Subscription bindSub;
        if (name == null) {
            throw new IllegalArgumentException("A name is required");
        }
        this.dependencyMap.put(name, () -> property.bindProperty().getValue());
        property.domainProperty.addListener(this::handlePropertyChange);
        Subscription domainSub = () -> validatedPropertyBase.domainProperty.removeListener(this::handlePropertyChange);
        this.listeners.add(domainSub);
        if (property.domainProperty != property.bindProperty()) {
            property.bindProperty().addListener(this::handlePropertyChange);
            bindSub = () -> property.bindProperty().removeListener(this::handlePropertyChange);
            this.listeners.add(bindSub);
        } else {
            bindSub = null;
        }
        return () -> {
            domainSub.dispose();
            this.listeners.remove(domainSub);
            if (bindSub != null) {
                bindSub.dispose();
                this.listeners.remove(bindSub);
            }
        };
    }

    @Override
    public Subscription dependency(String name, Property<?> property) {
        this.dependencyMap.put(name, () -> property.getValue());
        property.addListener(this::handlePropertyChange);
        Subscription s = () -> property.removeListener(this::handlePropertyChange);
        this.listeners.add(s);
        return () -> {
            s.dispose();
            this.listeners.remove(s);
        };
    }

    private void handlePropertyChange(Observable o, Object ol, Object ne) {
        this.runValidation();
    }

    @Override
    public void validate() {
        this._runValidation();
    }

    private void runValidation() {
        if (this.validationScheduled.getAndSet(true)) {
            return;
        }
        if (!this.onRequestOnly) {
            if (this.isBatchValidation()) {
                this.getOrCreatedExecutor().execute(this::_runValidation);
            } else {
                this._runValidation();
            }
        }
    }

    private void _runValidation() {
        Map map = Optional.ofNullable(this.dependencyMap).map(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Supplier)e.getValue()).get()))).orElse(new HashMap());
        this.validationStatusList.setAll((Collection)this.validationList.stream().map(f -> (Status)f.apply(this.bindProperty().getValue(), map)).collect(Collectors.toList()));
        this.status.setValue((Object)this.validationStatusList.stream().sorted(STATUS_SORTER).filter(WARNING_ERROR).findFirst().orElse(Status.ok()));
        this.validationScheduled.set(false);
    }

    @Override
    public void dispose() {
        this.listeners.forEach(e -> e.dispose());
        this.dependencyMap.clear();
        this.validationList.clear();
    }

    @Override
    public void reset() {
        this.status.set((Object)Status.ok());
    }

    @Override
    public void setOnRequestOnly(boolean onRequestOnly) {
        this.onRequestOnly = onRequestOnly;
    }

    @Override
    public boolean isOnRequestOnly() {
        return this.onRequestOnly;
    }
}

