/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WSash;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseSashRenderer<N>
extends BaseRenderer<MPartSashContainer, WSash<N>> {
    @Inject
    RendererFactory factory;
    private static final String AUTOHIDDEN_TAG = "_efx_AutoHidden";

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MPartSashContainer parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartSashContainer && BaseSashRenderer.this == (parent = (MPartSashContainer)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BaseSashRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BaseSashRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MPartSashContainer parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartSashContainer && BaseSashRenderer.this == (parent = (MPartSashContainer)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BaseSashRenderer.this.handleSelectedElement(parent, (MPartSashContainerElement)oldValue, (MPartSashContainerElement)newValue);
                }
            }
        });
        EventProcessor.attachVisibleProcessor(eventBroker, this);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/containerData/*", new EventHandler(){

            public void handleEvent(Event event) {
                MElementContainer parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj != null && changedObj.getParent() != null && changedObj.getParent().getRenderer() == BaseSashRenderer.this && (parent = changedObj.getParent()) != null && !BaseSashRenderer.this.inUIModification((MUIElement)parent)) {
                    @Nullable WSash widget = (WSash)BaseSashRenderer.this.getWidget((MUIElement)((MPartSashContainer)parent));
                    if (widget != null) {
                        widget.updateLayout();
                    } else {
                        BaseSashRenderer.this.getLogger().error("Could not find widget for '" + String.valueOf(parent) + "'");
                    }
                }
            }
        });
    }

    protected boolean detachHiddenChild() {
        return true;
    }

    @Override
    public boolean isChildRenderedAndVisible(@NonNull MUIElement u) {
        return this.detachHiddenChild() ? super.isChildRenderedAndVisible(u) : u.isToBeRendered();
    }

    @Override
    public void doProcessContent(MPartSashContainer element) {
        WSash sash = (WSash)this.getWidget((MUIElement)element);
        if (sash == null) {
            this.getLogger().error("Could not find widget for '" + String.valueOf(element) + "'");
            return;
        }
        ArrayList<WLayoutedWidget<MPartSashContainerElement>> list = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        for (MPartSashContainerElement e : element.getChildren()) {
            WLayoutedWidget widget;
            if (!e.isToBeRendered() || (widget = (WLayoutedWidget)this.engineCreateWidget(e)) == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            if (!this.detachHiddenChild()) {
                widget.setHidden(!this.isChildVisible((MUIElement)e));
            }
            list.add(widget);
        }
        sash.addItems(list);
    }

    public void showChild(@NonNull MPartSashContainer parent, @NonNull MUIElement element) {
        if (this.detachHiddenChild()) {
            super.showChild((MUIElement)parent, element);
        } else {
            ((WLayoutedWidget)element.getWidget()).setHidden(false);
        }
        if (!parent.isVisible() && parent.getTags().contains(AUTOHIDDEN_TAG)) {
            parent.getTags().remove(AUTOHIDDEN_TAG);
            parent.setVisible(true);
        }
    }

    public void childRendered(MPartSashContainer parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WSash sash = (WSash)this.getWidget((MUIElement)parentElement);
        if (sash == null) {
            this.getLogger().error("Could not find widget for '" + String.valueOf(parentElement) + "'");
            return;
        }
        WLayoutedWidget w = (WLayoutedWidget)element.getWidget();
        if (w != null) {
            List<@NonNull WLayoutedWidget<MPartSashContainerElement>> l = Collections.singletonList(w);
            sash.addItems(idx, l);
        } else {
            this.logger.error("The widget for element '" + String.valueOf(element) + "' should not be null");
        }
    }

    public void hideChild(MPartSashContainer container, MUIElement changedObj) {
        if (this.detachHiddenChild() || !changedObj.isToBeRendered()) {
            this.hideChildDetach(container, changedObj);
        } else {
            ((WLayoutedWidget)changedObj.getWidget()).setHidden(true);
        }
        if (container.isVisible() && container.getChildren().stream().noneMatch(MUIElement::isVisible) && !container.getTags().contains(AUTOHIDDEN_TAG)) {
            container.getTags().add(AUTOHIDDEN_TAG);
            container.setVisible(false);
        }
    }

    private void hideChildDetach(MPartSashContainer container, MUIElement changedObj) {
        WSash sash = (WSash)this.getWidget((MUIElement)container);
        if (sash == null) {
            return;
        }
        WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
        if (widget != null) {
            sash.removeItem(widget);
        }
    }

    void handleChildrenAddition(@NonNull MPartSashContainer parent, Collection<MPartSashContainerElement> elements) {
        for (MPartSashContainerElement element : elements) {
            this.syncElementTree((MUIElement)element);
            if (!element.isToBeRendered()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    void handleChildrenRemove(@NonNull MPartSashContainer parent, Collection<MPartSashContainerElement> elements) {
        for (MPartSashContainerElement element : elements) {
            if (!element.isToBeRendered() || element.getWidget() == null) continue;
            this.hideChildDetach(parent, (MUIElement)element);
        }
        this.checkSelectedElement((MUIElement)parent);
    }

    void handleSelectedElement(MPartSashContainer parent, MPartSashContainerElement oldElement, MPartSashContainerElement newElement) {
    }
}

