/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class UniqueIUAnalyzer
extends IUAnalyzer {
    Set<String> versionedNames = null;

    public void analyzeIU(IInstallableUnit iu) {
        String uniqueID = String.valueOf(iu.getId()) + ":" + iu.getVersion().toString();
        if (this.versionedNames.contains(uniqueID)) {
            this.error(iu, "[ERROR]" + iu.getId() + " with version: " + iu.getVersion() + " already exists in the repository");
            return;
        }
        this.versionedNames.add(uniqueID);
    }

    public void preAnalysis(IMetadataRepository repo) {
        this.versionedNames = new HashSet<String>();
    }
}

