/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.synchronize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoSetChangeEvent;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.SyncInfoTreeChangeEvent;

public class SyncInfoTree
extends SyncInfoSet {
    protected Map<IPath, Set<IResource>> parents = Collections.synchronizedMap(new HashMap());

    public SyncInfoTree() {
    }

    public SyncInfoTree(SyncInfo[] infos) {
        super(infos);
        SyncInfo[] syncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            IResource local = info.getLocal();
            this.addToParents(local, local);
            ++n2;
        }
    }

    public synchronized boolean hasMembers(IResource resource) {
        if (resource.getType() == 1) {
            return false;
        }
        IContainer parent = (IContainer)resource;
        if (parent.getType() == 8) {
            return !this.isEmpty();
        }
        IPath path = parent.getFullPath();
        Set<IResource> allDescendants = this.parents.get(path);
        return allDescendants != null && !allDescendants.isEmpty();
    }

    public synchronized SyncInfo[] getSyncInfos(IResource resource, int depth) {
        if (depth == 0 || resource.getType() == 1) {
            SyncInfo info = this.getSyncInfo(resource);
            if (info == null) {
                return new SyncInfo[0];
            }
            return new SyncInfo[]{info};
        }
        if (depth == 1) {
            IResource[] members;
            ArrayList<SyncInfo> result = new ArrayList<SyncInfo>();
            SyncInfo info = this.getSyncInfo(resource);
            if (info != null) {
                result.add(info);
            }
            IResource[] iResourceArray = members = this.members(resource);
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                info = this.getSyncInfo(member);
                if (info != null) {
                    result.add(info);
                }
                ++n2;
            }
            return result.toArray(new SyncInfo[result.size()]);
        }
        if (resource.getType() == 8) {
            return this.getSyncInfos();
        }
        return this.internalGetDeepSyncInfo((IContainer)resource);
    }

    private synchronized SyncInfo[] internalGetDeepSyncInfo(IContainer resource) {
        IResource[] children;
        ArrayList<SyncInfo> infos = new ArrayList<SyncInfo>();
        IResource[] iResourceArray = children = this.internalGetOutOfSyncDescendants(resource);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            SyncInfo info = this.getSyncInfo(child);
            if (info != null) {
                infos.add(info);
            } else {
                TeamPlugin.log(1, String.valueOf(Messages.SyncInfoTree_0) + child.getFullPath(), null);
            }
            ++n2;
        }
        return infos.toArray(new SyncInfo[infos.size()]);
    }

    @Override
    protected SyncInfoSetChangeEvent createEmptyChangeEvent() {
        return new SyncInfoTreeChangeEvent(this);
    }

    @Override
    public void add(SyncInfo info) {
        try {
            this.beginInput();
            boolean alreadyExists = this.getSyncInfo(info.getLocal()) != null;
            super.add(info);
            if (!alreadyExists) {
                IResource local = info.getLocal();
                this.addToParents(local, local);
            }
        }
        finally {
            this.endInput(null);
        }
    }

    @Override
    public void remove(IResource resource) {
        try {
            this.beginInput();
            super.remove(resource);
            this.removeFromParents(resource, resource);
        }
        finally {
            this.endInput(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.beginInput();
            super.clear();
            SyncInfoTree syncInfoTree = this;
            synchronized (syncInfoTree) {
                this.parents.clear();
            }
        }
        finally {
            this.endInput(null);
        }
    }

    private synchronized boolean addToParents(IResource resource, IResource parent) {
        if (parent.getType() == 8) {
            return false;
        }
        boolean addedParent = false;
        if (parent.getType() == 1) {
            addedParent = true;
        } else {
            Set<IResource> children = this.parents.get(parent.getFullPath());
            if (children == null) {
                children = new HashSet<IResource>();
                this.parents.put(parent.getFullPath(), children);
                addedParent = true;
            }
            children.add(resource);
        }
        if (!this.addToParents(resource, (IResource)parent.getParent()) && addedParent) {
            this.internalAddedSubtreeRoot(parent);
        }
        return addedParent;
    }

    private synchronized boolean removeFromParents(IResource resource, IResource parent) {
        if (parent.getType() == 8) {
            return false;
        }
        boolean removedParent = false;
        if (parent.getType() == 1) {
            removedParent = true;
        } else {
            Set<IResource> children = this.parents.get(parent.getFullPath());
            if (children != null) {
                children.remove(resource);
                if (children.isEmpty()) {
                    this.parents.remove(parent.getFullPath());
                    removedParent = true;
                }
            }
        }
        if (!this.removeFromParents(resource, (IResource)parent.getParent()) && removedParent) {
            this.internalRemovedSubtreeRoot(parent);
        }
        return removedParent;
    }

    private void internalAddedSubtreeRoot(IResource parent) {
        ((SyncInfoTreeChangeEvent)this.getChangeEvent()).addedSubtreeRoot(parent);
    }

    private void internalRemovedSubtreeRoot(IResource parent) {
        ((SyncInfoTreeChangeEvent)this.getChangeEvent()).removedSubtreeRoot(parent);
    }

    public void remove(IResource resource, int depth) {
        try {
            this.beginInput();
            if (this.getSyncInfo(resource) != null) {
                this.remove(resource);
            }
            if (depth == 0 || resource.getType() == 1) {
                return;
            }
            if (depth == 1) {
                IResource[] members;
                IResource[] iResourceArray = members = this.members(resource);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (this.getSyncInfo(member) != null) {
                        this.remove(member);
                    }
                    ++n2;
                }
            } else if (depth == 2) {
                IResource[] toRemove;
                IResource[] iResourceArray = toRemove = this.internalGetOutOfSyncDescendants((IContainer)resource);
                int n = toRemove.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource t = iResourceArray[n3];
                    this.remove(t);
                    ++n3;
                }
            }
        }
        finally {
            this.endInput(null);
        }
    }

    protected synchronized IResource[] internalGetOutOfSyncDescendants(IContainer resource) {
        Set<IResource> allChildren = this.parents.get(resource.getFullPath());
        if (allChildren == null) {
            return new IResource[0];
        }
        return allChildren.toArray(new IResource[allChildren.size()]);
    }

    private synchronized IResource[] internalMembers(IWorkspaceRoot root) {
        Set<IPath> possibleChildren = this.parents.keySet();
        HashSet<IProject> children = new HashSet<IProject>();
        for (IPath next : possibleChildren) {
            IResource element = root.findMember(next);
            if (element == null) continue;
            children.add(element.getProject());
        }
        return children.toArray(new IResource[children.size()]);
    }

    public synchronized IResource[] members(IResource resource) {
        if (resource.getType() == 1) {
            return new IResource[0];
        }
        IContainer parent = (IContainer)resource;
        if (parent.getType() == 8) {
            return this.internalMembers((IWorkspaceRoot)parent);
        }
        HashSet<IResource> children = new HashSet<IResource>();
        IPath path = parent.getFullPath();
        Set<IResource> possibleChildren = this.parents.get(path);
        if (possibleChildren != null) {
            Iterator<IResource> iterator = possibleChildren.iterator();
            while (iterator.hasNext()) {
                IResource next;
                IResource element = next = iterator.next();
                IPath childPath = element.getFullPath();
                IResource modelObject = null;
                if (childPath.segmentCount() == path.segmentCount() + 1) {
                    modelObject = element;
                } else if (childPath.segmentCount() > path.segmentCount()) {
                    IFolder childFolder = parent.getFolder((IPath)new Path(null, childPath.segment(path.segmentCount())));
                    modelObject = childFolder;
                }
                if (modelObject == null) continue;
                children.add(modelObject);
            }
        }
        return children.toArray(new IResource[children.size()]);
    }
}

