/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ClientConfigurator;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.ClientConfiguratorHolderClientConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.GetNegotiatedSubprotocolConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCCloseClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCConfiguratedClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCEchoServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCErrorClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCMatchedSubprotocolClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCSubprotocolServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpoint.WSCUnmatchedSubprotocolClientEndpoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_clientendpoint_web.war");
        archive.addClasses(new Class[]{GetNegotiatedSubprotocolConfigurator.class, OPS.class, WSCEchoServer.class, WSCSubprotocolServer.class});
        archive.addClasses(new Class[]{IOUtil.class, StringUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_clientendpoint_web");
    }

    @Test
    public void subprotocolsMatchTest() throws Exception {
        this.setAnnotatedClientEndpoint(WSCMatchedSubprotocolClientEndpoint.class);
        this.invoke("subprotocol", OPS.NEGOTIATED, new String[]{"MBLWS.huawei.com"});
    }

    @Test
    public void subprotocolsNotMatchTest() throws Exception {
        this.setAnnotatedClientEndpoint(WSCUnmatchedSubprotocolClientEndpoint.class);
        this.invoke("subprotocol", OPS.NEGOTIATED, new String[]{"{}"});
    }

    @Test
    public void configuratorTest() throws Exception {
        this.setAnnotatedClientEndpoint(WSCConfiguratedClientEndpoint.class);
        this.invoke("echo", OPS.ECHO_MSG, OPS.ECHO_MSG);
        ClientConfigurator configurator = ClientConfiguratorHolderClientConfigurator.getConfigurator();
        configurator.assertBeforeRequestHasBeenCalled();
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void onErrorWorksTest() throws Exception {
        WSCErrorClientEndpoint endpoint = new WSCErrorClientEndpoint();
        this.setAnnotatedClientEndpointInstance(endpoint);
        this.invoke("echo", OPS.ECHO_MSG, OPS.ECHO_MSG);
        WSClientIT.assertFalse((boolean)endpoint.onErrorCalled, (Object[])new Object[]{"@OnError has been unexpectedly called"});
        this.setCountDownLatchCount(2);
        this.setAnnotatedClientEndpointInstance(endpoint);
        this.invoke("echo", OPS.THROW, OPS.THROW);
        WSClientIT.assertTrue((boolean)endpoint.onErrorCalled, (Object[])new Object[]{"@OnError has NOT been called after RuntimeException is thrown on @OnMessage"});
        WSClientIT.logMsg((Object[])new Object[]{"@OnError has been called after RuntimeException is thrown on @OnMessage as expected"});
    }

    @Test
    public void onCloseWorksTest() throws Exception {
        WSCCloseClientEndpoint endpoint = new WSCCloseClientEndpoint();
        this.setAnnotatedClientEndpointInstance(endpoint);
        this.invoke("echo", OPS.ECHO_MSG.name(), OPS.ECHO_MSG.name(), false);
        WSClientIT.assertFalse((boolean)endpoint.onCloseCalled, (Object[])new Object[]{"@OnClose has been unexpectedly called"});
        this.cleanup();
        endpoint.waitForClose(this._ws_wait);
        WSClientIT.assertTrue((boolean)endpoint.onCloseCalled, (Object[])new Object[]{"@OnClose has NOT been called after session.close()"});
        WSClientIT.logMsg((Object[])new Object[]{"@OnClose has been called after session.close() as expected"});
    }
}

